/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.send.task;

import java.util.Enumeration;
import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.task.SingleTestSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptDomainGroupingManager;
import pluto.mail.MultiRcptInfo;
import pluto.mail.mx.LookupCacheManager;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

public class BulkTestSendTask
extends SingleTestSendTask {
    private static final Logger log = LoggerFactory.getLogger(BulkTestSendTask.class);

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.setTaskID(this.POST_ID.concat("_TEST"));
        this.setName(this.POST_ID + "_BulkTestSendTask");
        this.WORK_FILE_ID = this.POST_ID.concat("_bulk_test_").concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setSendType("MTEST");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("N");
        this.SPOOL_ANALYZER.setLimitDate("19000101");
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("bulk", domain);
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
        }
        if (this.SPOOL_POPPER == null) {
            if (log.isDebugEnabled()) {
                log.debug("No Test Data.... So Skip");
            }
            return;
        }
        MultiRcptDomainGroupingManager _DOMAIN_MANAGER_ = new MultiRcptDomainGroupingManager();
        String _NEXT_SPOOL_ = null;
        MultiRcptInfo _RCPT_TARGET_LIST_ = null;
        while ((_NEXT_SPOOL_ = (String)this.SPOOL_POPPER.next()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("READ SPOOL", (Object)_NEXT_SPOOL_);
            }
            if (_NEXT_SPOOL_.trim().length() < 1) continue;
            try {
                String domain = this.SPOOL_ANALYZER.pickupDomain(_NEXT_SPOOL_);
                if (domain == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("DOMAIN ERROR", (Object)_NEXT_SPOOL_);
                    }
                    this.processSyntaxErrorSpool(_NEXT_SPOOL_);
                    continue;
                }
                this.DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
                if (this.DOMAIN_NOT_FOUND_EXCEPTION != null) {
                    this.passDomainNotFound(_NEXT_SPOOL_, this.DOMAIN_NOT_FOUND_EXCEPTION);
                    continue;
                }
                try {
                    _RCPT_TARGET_LIST_ = _DOMAIN_MANAGER_.addMultipleRcptElement(_NEXT_SPOOL_, domain);
                }
                catch (DomainFullException e) {
                    Enumeration myEnum = _DOMAIN_MANAGER_.elements();
                    while (myEnum.hasMoreElements()) {
                        _RCPT_TARGET_LIST_ = (MultiRcptInfo)myEnum.nextElement();
                        String result = null;
                        result = _RCPT_TARGET_LIST_.getResult();
                        if (result == null) {
                            _DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
                            continue;
                        }
                        BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
                        pool.push(result);
                    }
                    continue;
                }
                if (_RCPT_TARGET_LIST_ == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_RCPT_TARGET_LIST_.getDomain() + " is keep into Manager");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(_RCPT_TARGET_LIST_.getDomain() + " is sending");
                }
                BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
                pool.push(_RCPT_TARGET_LIST_.getResult());
            }
            catch (OutOfMemoryError outError) {
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.currentThread();
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception pool) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(_NEXT_SPOOL_);
                }
                catch (Exception pool) {
                }
            }
            catch (Throwable err) {
                log.error("error", err);
                ErrorSpoolLogger.put(_NEXT_SPOOL_);
            }
        }
        Enumeration myEnum = _DOMAIN_MANAGER_.elements();
        while (myEnum.hasMoreElements()) {
            _RCPT_TARGET_LIST_ = (MultiRcptInfo)myEnum.nextElement();
            String result = null;
            result = _RCPT_TARGET_LIST_.getResult();
            if (result == null) {
                _DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
                continue;
            }
            BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
            pool.push(result);
        }
        _DOMAIN_MANAGER_.clear();
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }
}

