/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.send.task;

import java.util.Enumeration;
import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import jupiter.mass.send.task.SingleBaseSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptDomainGroupingManager;
import pluto.mail.MultiRcptInfo;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.NoSpoolFileException;
import venus.spool.common.popper.Popper;

public class BulkBaseSendTask
extends SingleBaseSendTask {
    private static final Logger log = LoggerFactory.getLogger(BulkBaseSendTask.class);

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_BulkBaseSendTask");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_bulk_").concat(Cal.getSerialDate());
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            try {
                this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
            }
            catch (NoSpoolFileException thw) {
                return;
            }
        }
        if (this.SPOOL_POPPER == null) {
            if (log.isDebugEnabled()) {
                log.debug("No Real Data.... So Skip");
            }
            return;
        }
        MultiRcptDomainGroupingManager _DOMAIN_MANAGER_ = new MultiRcptDomainGroupingManager();
        String _NEXT_SPOOL_ = null;
        MultiRcptInfo _RCPT_TARGET_LIST_ = null;
        int _SEND_COUNT_ = 0;
        while ((_NEXT_SPOOL_ = (String)this.SPOOL_POPPER.next()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("READ SPOOL:" + _NEXT_SPOOL_);
            }
            if (_NEXT_SPOOL_.trim().length() < 1) {
                if (!log.isDebugEnabled()) continue;
                log.debug("SKIP LENGTH 0 SPOOL:" + _NEXT_SPOOL_);
                continue;
            }
            if (_SEND_COUNT_++ > STOP_CHECK_RECYCLE) {
                if (this.execute_StopCheck()) {
                    throw new SendStopException(this.getName() + " receive stop signal");
                }
                _SEND_COUNT_ = 0;
            }
            try {
                String domain = this.SPOOL_ANALYZER.pickupDomain(_NEXT_SPOOL_);
                if (domain == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("SKIP DOMAIN ERROR:" + _NEXT_SPOOL_);
                    }
                    this.processSyntaxErrorSpool(_NEXT_SPOOL_);
                    continue;
                }
                if (MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain)) {
                    this.passRejectDomain(_NEXT_SPOOL_);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("MailSendDomainFilter Reject:" + _NEXT_SPOOL_);
                    continue;
                }
                this.DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
                if (this.DOMAIN_NOT_FOUND_EXCEPTION != null && this.DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException) {
                    this.passDomainNotFound(_NEXT_SPOOL_, this.DOMAIN_NOT_FOUND_EXCEPTION);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("DOMAIN_NOT_FOUND_EXCEPTION SKIP:" + _NEXT_SPOOL_);
                    continue;
                }
                try {
                    _RCPT_TARGET_LIST_ = _DOMAIN_MANAGER_.addMultipleRcptElement(_NEXT_SPOOL_, domain);
                }
                catch (DomainFullException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("DomainFullException !!!");
                    }
                    Enumeration myEnum = _DOMAIN_MANAGER_.elements();
                    while (myEnum.hasMoreElements()) {
                        _RCPT_TARGET_LIST_ = (MultiRcptInfo)myEnum.nextElement();
                        String result = null;
                        result = _RCPT_TARGET_LIST_.getResult();
                        if (result == null) {
                            _DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
                            continue;
                        }
                        BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
                        if (log.isDebugEnabled()) {
                            log.debug("regist:" + result);
                        }
                        pool.push(result);
                    }
                    continue;
                }
                if (_RCPT_TARGET_LIST_ == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("REGIST DOMAIN CONTINUE:" + _NEXT_SPOOL_);
                    continue;
                }
                BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
                if (log.isDebugEnabled()) {
                    log.debug("regist:" + _RCPT_TARGET_LIST_.getResult());
                }
                pool.push(_RCPT_TARGET_LIST_.getResult());
            }
            catch (OutOfMemoryError outError) {
                if (log.isDebugEnabled()) {
                    log.debug("outof memory..!!!!");
                }
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.currentThread();
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception pool) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(_NEXT_SPOOL_);
                }
                catch (Exception pool) {
                }
            }
            catch (Throwable err) {
                log.error("error", err);
                ErrorSpoolLogger.put(_NEXT_SPOOL_);
            }
        }
        Enumeration myEnum = _DOMAIN_MANAGER_.elements();
        while (myEnum.hasMoreElements()) {
            _RCPT_TARGET_LIST_ = (MultiRcptInfo)myEnum.nextElement();
            String result = null;
            result = _RCPT_TARGET_LIST_.getResult();
            if (result == null) {
                _DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
                continue;
            }
            BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
            if (log.isDebugEnabled()) {
                log.debug("regist:" + result);
            }
            pool.push(result);
        }
        _DOMAIN_MANAGER_.clear();
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("bulk", domain);
    }
}

