/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator.sync;

import java.util.HashMap;
import java.util.Map;
import jupiter.mass.log.updator.sync.DbSynchroSwithing;
import jupiter.mass.log.updator.sync.LocalSynchroSwitching;
import jupiter.mass.log.updator.sync.SwitchingService;
import jupiter.mass.log.updator.sync.TableInfo;

public class SwitchingFactory {
    private static final SwitchingFactory switchFactory = new SwitchingFactory();
    private final Map<String, SwitchingService> switchList = new HashMap<String, SwitchingService>();

    private SwitchingFactory() {
    }

    public static SwitchingFactory getSwitchingFactory() {
        return switchFactory;
    }

    public synchronized SwitchingService getInstance(String key) {
        if (!this.switchList.containsKey(key)) {
            this.switchList.put(key, new LocalSynchroSwitching());
        }
        return this.switchList.get(key);
    }

    public synchronized SwitchingService getInstance(TableInfo key) {
        if (!this.switchList.containsKey(key.getCodeCode())) {
            this.switchList.put(key.getCodeCode(), new DbSynchroSwithing(key));
        }
        return this.switchList.get(key.getCodeCode());
    }

    public synchronized void remove(String key) {
        if (this.switchList.containsKey(key)) {
            this.switchList.remove(key);
        }
    }
}

