/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import com.humuson.tms.constrants.ChannelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;

public class UpdatorCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(UpdatorCheckTask.class);
    private static final String _USE_OTHER_DB_ = "use.other.db";
    private static String MAX_THREAD_SIZE = "3";
    private static String ONE_THREAD_CNT = "1000";
    private static String ONE_INTERVAL_CNT = "1000";
    private static String channelType;
    private static String UPDATE_CLASS_NAME;
    private static String FATIGUE_CHECK_FLAG;
    private static String moduleName;
    private static String querySelectListTableName;
    private static String queryListSelectTargetRange;
    protected eMsConnection emsConnection = null;
    protected eMsStatement selectSearchStatement = null;
    private static boolean isUseOtherDb;
    private static ConnectInfo moduleConnectionInformation;

    public UpdatorCheckTask() {
        super((short)2);
        this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("UpdatorCheckTask");
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        ONE_THREAD_CNT = prop.getProperty("one.thread.cnt", "1000");
        MAX_THREAD_SIZE = prop.getProperty("max.thread.size", "10");
        ONE_INTERVAL_CNT = prop.getProperty("commit.interval.size", "1000");
        channelType = prop.getProperty("channel.type", "");
        UPDATE_CLASS_NAME = prop.getProperty("update.class.name", "");
        FATIGUE_CHECK_FLAG = prop.getProperty("fatigue.check.yn", "N");
        isUseOtherDb = Boolean.parseBoolean(prop.getProperty(_USE_OTHER_DB_, "false"));
        if (channelType.equals(ChannelType.SMS.getCode())) {
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("sms.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("sms.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
        } else if (channelType.equals(ChannelType.KAKAO.getCode())) {
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
        } else {
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("other.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("other.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("other.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("other.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("other.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("other.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("other.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("other.db.in.charset"));
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        log.info("UpdatorCheckTask_START");
        this.emsConnection = isUseOtherDb ? ConnectionPool.getConnection(moduleConnectionInformation) : ConnectionPool.getConnection();
        try {
            this.selectSearchStatement = this.emsConnection.createStatement();
        }
        catch (Exception e) {
            if (this.emsConnection == null) {
                this.emsConnection = ConnectionPool.getConnection();
                this.selectSearchStatement = this.emsConnection.createStatement();
            }
            log.error("create statement error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("{} Request Connection Error", (Object)this.getName(), (Object)thw);
    }

    @Override
    public void release_Resource() {
        if (this.emsConnection != null) {
            this.emsConnection.recycleStatement(this.selectSearchStatement);
            this.emsConnection.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (querySelectListTableName.isEmpty() || queryListSelectTargetRange.isEmpty()) {
            return;
        }
        ArrayList<String> listTables = new ArrayList<String>();
        Properties result = new Properties();
        eMsResultSet rs = null;
        try (eMsResultSet rsListTableName = null;){
            rsListTableName = this.selectSearchStatement.executeQuery(querySelectListTableName);
            if (rsListTableName.next()) {
                String listTableName1 = null;
                String listTableName2 = null;
                if ("KA".equalsIgnoreCase(channelType)) {
                    listTableName1 = rsListTableName.getString("LIST_TABLE1") == null ? "" : rsListTableName.getString("LIST_TABLE1");
                    listTableName2 = rsListTableName.getString("LIST_TABLE2") == null ? "" : rsListTableName.getString("LIST_TABLE2");
                } else {
                    listTableName1 = rsListTableName.getString("SMS_LIST_TABLE1") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE1");
                    String string = listTableName2 = rsListTableName.getString("SMS_LIST_TABLE2") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE2");
                }
                if (listTableName1.isEmpty() && listTableName2.isEmpty()) {
                    return;
                }
                if (listTableName1.equals(listTableName2)) {
                    listTables.add(listTableName1);
                } else {
                    listTables.add(listTableName1);
                    listTables.add(listTableName2);
                }
            }
            if (listTables.isEmpty()) {
                log.debug("LIST TABLE NAME is empty.");
                return;
            }
            StringBuffer buffer = new StringBuffer();
            HashMap<String, Properties> executions = new HashMap<String, Properties>();
            for (String string : listTables) {
                try {
                    buffer.setLength(0);
                    StringConvert.ConvertString(buffer, queryListSelectTargetRange, "${SMS_LIST_TABLE}", string);
                    if (log.isErrorEnabled()) {
                        log.debug("QUERY_SELECT_TARGET_RANGE query: {}", (Object)buffer.toString());
                    }
                    if ((rs = this.selectSearchStatement.executeQuery(buffer.toString())).next()) {
                        rs.putToMap(result, false);
                    }
                    if (result.isEmpty()) {
                        log.warn("Get Target Range Result is empty.");
                        continue;
                    }
                    int totalCount = Integer.parseInt(result.getProperty("TO_CNT", "0"));
                    if (totalCount < 1) {
                        log.warn("Get Target Range Result is zero.");
                        continue;
                    }
                    executions.putAll(this.getThreadInfo(result.getProperty("MIN_ID", "0"), result.getProperty("MAX_ID", "0"), string));
                    if (!executions.isEmpty()) continue;
                    log.warn("{} Update Execute Information is null.", (Object)this.getName());
                }
                catch (Exception e) {
                    log.error("execute error", (Throwable)e);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            log.info("executions size : {}", (Object)executions.size());
            for (Map.Entry entry : executions.entrySet()) {
                String key = (String)entry.getKey();
                Properties value = (Properties)entry.getValue();
                value.setProperty("FATIGUE_CHECK_FLAG", FATIGUE_CHECK_FLAG);
                value.setProperty(_USE_OTHER_DB_, String.valueOf(isUseOtherDb));
                log.info("{} execute_createTask... KEY: {}, VALUE: {}", new Object[]{this.getName(), key, value});
                try {
                    this.execute_createTask(value);
                }
                catch (Exception e) {
                    log.error("[ERROR] execute_createTask...", (Throwable)e);
                }
            }
        }
        log.info("{} START is execute execute_createTask method...[OK]", (Object)this.getName());
    }

    private synchronized void execute_createTask(Properties info) throws Exception {
        try {
            Task make_info = (Task)this.getInstance(UPDATE_CLASS_NAME);
            make_info.setTaskProperty(info);
            TaskManager.executeTask(make_info);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        catch (AlreadyRegistTaskException e) {
            log.info("AlreadyRegistTaskException is skip {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("{} executeTask error", (Object)UPDATE_CLASS_NAME, (Object)e);
        }
    }

    private Object getInstance(String className) throws Exception {
        return Class.forName(className).newInstance();
    }

    private Map<String, Properties> getThreadInfo(String min, String max, String listTable) throws Exception {
        int processCountPerThread = Integer.parseInt(ONE_THREAD_CNT);
        int intervalCnt = Integer.parseInt(ONE_INTERVAL_CNT);
        long maxSeq = Long.parseLong(max);
        long minSeq = Long.parseLong(min);
        int range = (int)(maxSeq - minSeq);
        HashMap<String, Properties> selectInfo = new HashMap<String, Properties>();
        int remain = range;
        if (remain > processCountPerThread) {
            maxSeq = minSeq + (long)processCountPerThread - 1L;
        }
        if (maxSeq != minSeq) {
            Properties processInfo = new Properties();
            processInfo.setProperty("MAX_ID", Long.toString(maxSeq));
            processInfo.setProperty("MIN_ID", Long.toString(minSeq));
            processInfo.setProperty("CHECK_INTERVAL", Long.toString(intervalCnt));
            processInfo.setProperty("THREAD_ID", listTable);
            processInfo.setProperty("SMS_LIST_TABLE", listTable);
            selectInfo.put(listTable, processInfo);
        }
        return selectInfo;
    }

    private int divideCeil(int ramin, int processCount) {
        int val = 0;
        try {
            float leaves = ramin % processCount;
            val = leaves > 0.0f ? ramin / processCount + 1 : ramin / processCount;
        }
        catch (Exception e) {
            return 0;
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        UpdatorCheckTask test = new UpdatorCheckTask();
        Map<String, Properties> executions = test.getThreadInfo("50000", "70000", "EM_MMS_LOG");
        for (Map.Entry<String, Properties> exec : executions.entrySet()) {
            String key = exec.getKey();
            Properties value = exec.getValue();
            System.out.println(value.toString());
        }
    }

    static {
        FATIGUE_CHECK_FLAG = "N";
        moduleName = null;
        querySelectListTableName = null;
        queryListSelectTargetRange = null;
        isUseOtherDb = false;
        moduleConnectionInformation = new ConnectInfo();
        try {
            moduleName = eMsSystem.getProperty("module.name", "common_update");
            log.info("Module Name : {}", (Object)moduleName);
            querySelectListTableName = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_LIST_TABLE");
            queryListSelectTargetRange = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_RANGE");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ERROR static variable setting.", (Throwable)e);
            System.exit(1);
        }
    }
}

