/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import com.humuson.tms.constrants.CommonType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import jupiter.mass.log.updator.SmsAutoUpdator;
import jupiter.mass.log.updator.SmsCampUpdator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;

public class SmsUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SmsUpdator.class);
    private String QUERY_SELECT_TARGET_SMS_LIST_TABLE = null;
    private String QUERY_TARGET_SMS_RESULT_QUERY = null;
    private String QUERY_TARGET_FATIGUE_RESULT_QUERY = null;
    public static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    public static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
    public String UPDATE_TMS_SMS_QUE_LOG = null;
    private String THREAD_ID = null;
    private int LIMIT_SMS_UPDATE_CNT = 1000;
    protected Hashtable<String, ScheduleTblBean> CAMP_SCHEDULE_PPT = new Hashtable();
    protected Hashtable<String, ScheduleTblBean> AUTO_SCHEDULE_PPT = new Hashtable();
    protected List<Properties> AUTO_TARGETLIST = null;
    protected List<Properties> CAMP_TARGETLIST = null;
    protected List<Properties> FATIGUE_CHECK_LIST = null;
    protected List<Properties> SMS_TARGETLIST = null;
    private static ConnectInfo connectInfo = new ConnectInfo();
    private static String moduleName = null;

    public SmsUpdator() {
        this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_SMS_LIST_TABLE");
        this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_TARGET_SMS_RESULT_QUERY");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
        this.UPDATE_TMS_SMS_QUE_LOG = SqlManager.getQuery(moduleName.toUpperCase(), "UPDATE_TMS_SMS_QUE_LOG");
        this.QUERY_TARGET_FATIGUE_RESULT_QUERY = SqlManager.getQuery("FATIGUE", "QUERY_TARGET_FATIGUE_RESULT_QUERY");
        this.AUTO_TARGETLIST = new ArrayList<Properties>();
        this.CAMP_TARGETLIST = new ArrayList<Properties>();
        this.SMS_TARGETLIST = new ArrayList<Properties>();
        this.FATIGUE_CHECK_LIST = new ArrayList<Properties>();
    }

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setName("SmsUpdator");
        this.setTaskID("SmsUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
        this.THREAD_ID = this.TASK_PROPERTY.getProperty("THREAD_ID");
        this.LIMIT_SMS_UPDATE_CNT = Integer.parseInt(this.TASK_PROPERTY.getProperty("CHECK_INTERVAL"));
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL SmsUpdator===> execute()");
        }
        try {
            this.excute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("SmsUpdator CALL execute() ERROR", thw);
            thw.printStackTrace();
        }
        finally {
            this.releaseResource();
        }
    }

    protected void excute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL SmsUpdator===> execute_init()");
        }
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL SMSUpdator===> releaseResource()");
        }
    }

    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL SMSUpdator===> execute_main()");
        }
        this.update_process(this.TASK_PROPERTY.getProperty("SMS_LIST_TABLE", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        log.debug("update_process start");
        eMsConnection moduleConnection = null;
        eMsStatement moduleSmsStmt = null;
        eMsResultSet moduleSmsResult = null;
        SmsAutoUpdator autoUpt = new SmsAutoUpdator();
        SmsCampUpdator campUpt = new SmsCampUpdator();
        Properties resultQueryProp = new Properties();
        resultQueryProp.setProperty("SMS_LIST_TABLE", list_table);
        resultQueryProp.setProperty("MAX_ID", this.TASK_PROPERTY.getProperty("MAX_ID"));
        resultQueryProp.setProperty("MIN_ID", this.TASK_PROPERTY.getProperty("MIN_ID"));
        try {
            moduleConnection = ConnectionPool.getConnection(connectInfo);
            moduleSmsStmt = moduleConnection.createStatement();
            this.QUERY_TARGET_SMS_RESULT_QUERY = this.ppsParseSQL(this.QUERY_TARGET_SMS_RESULT_QUERY, "SMS_LIST_TABLE", list_table, "@{", "}");
            moduleSmsResult = moduleSmsStmt.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY, resultQueryProp, "${", "}");
            String currentList = "";
            String nextList = "";
            String campCurrentList = "";
            String campNextList = "";
            while (moduleSmsResult.next()) {
                Properties smsSendResultValue = new Properties();
                smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);
                moduleSmsResult.putToMap(smsSendResultValue, false);
                String postId = smsSendResultValue.getProperty("POST_ID").trim();
                String memberId = "";
                if (smsSendResultValue.getProperty("CHANNEL_TYPE").equals(CommonType.AUTO.getCode())) {
                    block29: {
                        int posPostId = postId.lastIndexOf("_");
                        if (posPostId < 0) continue;
                        String workDay = postId.substring(0, posPostId);
                        String seqNo = postId.substring(posPostId + 1);
                        smsSendResultValue.setProperty("WORKDAY", workDay);
                        smsSendResultValue.setProperty("SEQNO", seqNo);
                        String tempMemberId = smsSendResultValue.getProperty("MEMBER_ID").trim();
                        int posMemberId = tempMemberId.indexOf("_");
                        if (posMemberId < 0) continue;
                        if (currentList == "") {
                            currentList = smsSendResultValue.getProperty("LIST_TABLE", "");
                        }
                        nextList = smsSendResultValue.getProperty("LIST_TABLE", "");
                        memberId = tempMemberId.substring(0, posMemberId);
                        String memberIdSeq = tempMemberId.substring(posMemberId + 1);
                        smsSendResultValue.put("M_ID", memberId);
                        smsSendResultValue.put("M_ID_SEQ", memberIdSeq);
                        if (currentList.equals(nextList)) {
                            try {
                                autoUpt.addTargetData(smsSendResultValue, list_table);
                                break block29;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if (autoUpt.listTableBatchUpdate(currentList) > 0) {
                            autoUpt.schdSummary();
                            currentList = nextList;
                            autoUpt.addTargetData(smsSendResultValue, list_table);
                        }
                    }
                    if (autoUpt.getSize() > 0 && autoUpt.getSize() % this.LIMIT_SMS_UPDATE_CNT == 0) {
                        log.debug("LIMIT_SMS_UPDATE_CNT : {}", (Object)this.LIMIT_SMS_UPDATE_CNT);
                        if (autoUpt.listTableBatchUpdate(currentList) > 0) {
                            autoUpt.schdSummary();
                            this.smsTableBatchUpdate(list_table);
                        }
                    }
                } else {
                    block30: {
                        if (campCurrentList == "") {
                            log.debug("LIST_TABLE {}", (Object)smsSendResultValue.getProperty("LIST_TABLE", ""));
                            campCurrentList = smsSendResultValue.getProperty("LIST_TABLE", "");
                        }
                        memberId = smsSendResultValue.getProperty("MEMBER_ID").trim();
                        campNextList = smsSendResultValue.getProperty("LIST_TABLE", "");
                        if (campCurrentList.equals(campNextList)) {
                            try {
                                campUpt.addTargetData(smsSendResultValue, list_table);
                                break block30;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if (campUpt.listTableBatchUpdate(campCurrentList) > 0) {
                            campUpt.schdSummary();
                            this.smsTableBatchUpdate(list_table);
                            campCurrentList = campNextList;
                            campUpt.addTargetData(smsSendResultValue, list_table);
                        }
                    }
                    if (campUpt.getSize() > 0 && campUpt.getSize() % this.LIMIT_SMS_UPDATE_CNT == 0 && campUpt.listTableBatchUpdate(campCurrentList) > 0) {
                        campUpt.schdSummary();
                        this.smsTableBatchUpdate(list_table);
                    }
                }
                String FATIGUE_USE_YN = eMsSystem.getProperty("fatigue.yn", "N");
                if ("Y".equals(FATIGUE_USE_YN) && this.TASK_PROPERTY.getProperty("FATIGUE_CHECK_FLAG", "N").equals("Y") && Integer.parseInt(smsSendResultValue.getProperty("FAIL_CNT")) > 0) {
                    smsSendResultValue.setProperty("MEMBER_ID", memberId);
                    smsSendResultValue.setProperty("FATIGUE_DATE", postId.substring(0, 8));
                    this.FATIGUE_CHECK_LIST.add(smsSendResultValue);
                    if (this.FATIGUE_CHECK_LIST.size() % this.LIMIT_SMS_UPDATE_CNT == 0) {
                        this.fatigueTableBatchUpdate("DAY");
                        this.fatigueTableBatchUpdate("MONTH");
                    }
                }
                this.SMS_TARGETLIST.add(smsSendResultValue);
            }
            if (autoUpt.getSize() > 0) {
                autoUpt.listTableBatchUpdate(currentList);
                autoUpt.schdSummary();
            }
            if (campUpt.getSize() > 0) {
                campUpt.listTableBatchUpdate(campCurrentList);
                campUpt.schdSummary();
            }
            if (this.SMS_TARGETLIST.size() > 0) {
                this.smsTableBatchUpdate(list_table);
            }
        }
        catch (Exception e) {
            log.error("[ERROR] SmsUpdator update_process()", (Throwable)e);
        }
        finally {
            if (moduleSmsResult != null) {
                moduleSmsResult.close();
            }
            if (moduleSmsStmt != null) {
                moduleSmsStmt.close();
            }
            if (moduleConnection != null) {
                moduleConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int smsTableBatchUpdate(String list_table) throws SQLException {
        int successCnt;
        block13: {
            block12: {
                successCnt = 0;
                eMsConnection emscon = null;
                eMsPreparedStatement batchPstmt = null;
                String query = "";
                try {
                    emscon = ConnectionPool.getConnection(connectInfo);
                    log.debug("UPDATE_TMS_SMS_QUE_LOG : {}", (Object)this.UPDATE_TMS_SMS_QUE_LOG);
                    emscon.setAutoCommit(false);
                    query = this.ppsParseSQL(this.UPDATE_TMS_SMS_QUE_LOG, "SMS_LIST_TABLE", list_table, "@{", "}");
                    batchPstmt = emscon.prepareStatement(query, "${", "}");
                    for (Properties prop : this.SMS_TARGETLIST) {
                        batchPstmt.addBatch(prop);
                    }
                    successCnt = batchPstmt.executeBatch().length;
                    if (batchPstmt != null) {
                        emscon.recycleStatement(batchPstmt);
                    }
                    if (emscon == null) break block12;
                }
                catch (Exception e) {
                    log.error("batchUpdate error : {}", (Throwable)e);
                    emscon.rollback();
                    for (Properties prop : this.SMS_TARGETLIST) {
                        try {
                            batchPstmt.executeUpdate(prop);
                            emscon.commit();
                        }
                        catch (Exception ex) {
                            log.error("batchUpdate oneToOne error : {}", (Throwable)ex);
                        }
                    }
                    break block13;
                }
                finally {
                    if (batchPstmt != null) {
                        emscon.recycleStatement(batchPstmt);
                    }
                    if (emscon != null) {
                        emscon.commit();
                        emscon.setAutoCommit(true);
                        emscon.recycle();
                    }
                    this.SMS_TARGETLIST.clear();
                }
                emscon.commit();
                emscon.setAutoCommit(true);
                emscon.recycle();
            }
            this.SMS_TARGETLIST.clear();
        }
        return successCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fatigueTableBatchUpdate(String dateType) throws SQLException {
        int successCnt;
        block13: {
            block12: {
                successCnt = 0;
                eMsConnection emscon = null;
                eMsPreparedStatement batchPstmt = null;
                String query = "";
                try {
                    emscon = ConnectionPool.getConnection();
                    log.info("QUERY_TARGET_FATIGUE_RESULT_QUERY : {}", (Object)this.QUERY_TARGET_FATIGUE_RESULT_QUERY);
                    emscon.setAutoCommit(false);
                    query = this.ppsParseSQL(this.QUERY_TARGET_FATIGUE_RESULT_QUERY, "FATIGUE_LIST", this.setFatigueTable(dateType), "@{", "}");
                    log.info("QUERY_TARGET_FATIGUE_RESULT_QUERY : {}", (Object)query);
                    batchPstmt = emscon.prepareStatement(query, "${", "}");
                    for (Properties prop : this.FATIGUE_CHECK_LIST) {
                        batchPstmt.addBatch(prop);
                    }
                    successCnt = batchPstmt.executeBatch().length;
                    if (batchPstmt != null) {
                        emscon.recycleStatement(batchPstmt);
                    }
                    if (emscon == null) break block12;
                }
                catch (Exception e) {
                    log.error("batchUpdate error : {}", (Throwable)e);
                    emscon.rollback();
                    for (Properties prop : this.FATIGUE_CHECK_LIST) {
                        try {
                            batchPstmt.executeUpdate(prop);
                            emscon.commit();
                        }
                        catch (Exception ex) {
                            log.error("batchUpdate oneToOne error : {}", (Throwable)ex);
                        }
                    }
                    break block13;
                }
                finally {
                    if (batchPstmt != null) {
                        emscon.recycleStatement(batchPstmt);
                    }
                    if (emscon != null) {
                        emscon.commit();
                        emscon.setAutoCommit(true);
                        emscon.recycle();
                    }
                    this.FATIGUE_CHECK_LIST.clear();
                }
                emscon.commit();
                emscon.setAutoCommit(true);
                emscon.recycle();
            }
            this.FATIGUE_CHECK_LIST.clear();
        }
        return successCnt;
    }

    public String setFatigueTable(String dateType) {
        if (dateType.equals("DAY")) {
            return "TMS_FATIGUE_SMS_DAY_LIST";
        }
        if (dateType.equals("MONTH")) {
            return "TMS_FATIGUE_SMS_MONTH_LIST";
        }
        return "TMS_FATIGUE_SMS_LIST";
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return SmsUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("SmsUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("SmsUpdator init error", thw);
    }

    protected String getMonthListTableName(String month, String type) {
        String string = month = month.length() == 1 ? "0" + month : month;
        if (type.equals("AUTO")) {
            return "TMS_AUTO_SEND_LIST_" + month;
        }
        return "TMS_CAMP_SEND_LIST_" + month;
    }

    static {
        moduleName = eMsSystem.getProperty("module.name", "common_update");
        connectInfo.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
        connectInfo.setDB_URL(eMsSystem.getProperty("sms.db.url"));
        connectInfo.setDB_UID(eMsSystem.getProperty("sms.db.id"));
        connectInfo.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
        connectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
        connectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
        connectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
        connectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
    }
}

