/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import jupiter.mass.log.updator.PushAutoUpdator;
import jupiter.mass.log.updator.PushCampUpdator;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class PushUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushUpdator.class);
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsStatement TMS_PUSH_SELECT_STMT = null;
    private eMsStatement MODULE_PUSH_SELECT_STMT = null;
    private eMsStatement MODULE_PUSH_UPDATE_STMT = null;
    private String QUERY_SELECT_TARGET_PUSH_LIST_TABLE = null;
    private String QUERY_TARGET_PUSH_RESULT_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
    private String THREAD_ID = null;
    private Hashtable CAMP_SCHEDULE_PPT = new Hashtable();
    private Hashtable AUTO_SCHEDULE_PPT = new Hashtable();
    private Hashtable PPS_LIST = new Hashtable();
    public static final String OPEN_TYPE = "R";
    public static final String CLICK_TYPE = "C";

    public PushUpdator() {
        this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_PUSH_LIST_TABLE");
        this.QUERY_TARGET_PUSH_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_PUSH_RESULT_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
    }

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setName("PushUpdator");
        this.setTaskID("PushUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
        this.THREAD_ID = this.TASK_PROPERTY.getProperty("THREAD_ID");
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("PushUpdator", (Object)"CALL execute() ERROR", (Object)thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected String getMonthListTableName(String month, String type) {
        String string = month = month.length() == 1 ? "0" + month : month;
        if ("AUTO".equals(type)) {
            return "TMS_AUTO_SEND_LIST_" + month;
        }
        return "TMS_CAMP_SEND_LIST_" + month;
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushUpdator===> execute_init()");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        this.CAMP_SCHEDULE_PPT.clear();
        this.AUTO_SCHEDULE_PPT.clear();
        this.TMS_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_PUSH_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushUpdator===> releaseResource()");
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
            this.SOURCE_CONNECTION.recycleStatement(this.MODULE_PUSH_SELECT_STMT);
            this.SOURCE_CONNECTION.recycleStatement(this.MODULE_PUSH_UPDATE_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushUpdator===> execute_main()");
        }
        Properties tValue = new Properties();
        try (eMsResultSet pushListTableResult = null;){
            pushListTableResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE);
            while (pushListTableResult.next()) {
                if (pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", pushListTableResult.getString("LIST_TABLE1").toString());
                    continue;
                }
                pushListTableResult.putToMap(tValue, false);
            }
            if (pushListTableResult != null) {
                pushListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String pushListTable = iter.next().toString();
                if (!pushListTable.equals("") && !pushListTable.equals(null)) {
                    this.update_process(pushListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        eMsResultSet modulePushResult = null;
        Properties pushSendResultValue = new Properties();
        ScheduleTblBean stBean = null;
        ScheduleTblBean autoStBean = null;
        String postId = "";
        int posPostid = 0;
        String workDay = "";
        String seqNo = "";
        String maxId = "";
        String minId = "";
        PushAutoUpdator autoUpt = new PushAutoUpdator();
        PushCampUpdator campUpt = new PushCampUpdator();
        try {
            maxId = this.TASK_PROPERTY.getProperty("MAX_ID");
            minId = this.TASK_PROPERTY.getProperty("MIN_ID");
            pushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
            pushSendResultValue.setProperty("MAX_ID", maxId);
            pushSendResultValue.setProperty("MIN_ID", minId);
            modulePushResult = this.MODULE_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_RESULT_QUERY, pushSendResultValue, "${", "}");
            campUpt.init_con(list_table);
            autoUpt.init_con(list_table);
            while (modulePushResult.next()) {
                pushSendResultValue.clear();
                pushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
                modulePushResult.putToMap(pushSendResultValue, false);
                postId = pushSendResultValue.getProperty("POST_ID").trim();
                if (pushSendResultValue.getProperty("REQ_UID").startsWith("A")) {
                    posPostid = postId.indexOf(95);
                    workDay = postId.substring(0, posPostid);
                    seqNo = postId.substring(posPostid + 1);
                    pushSendResultValue.setProperty("WORKDAY", workDay);
                    pushSendResultValue.setProperty("SEQNO", seqNo);
                    try {
                        autoUpt.update(pushSendResultValue, list_table);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    autoStBean = (ScheduleTblBean)this.AUTO_SCHEDULE_PPT.get(postId);
                    if (autoStBean == null) {
                        autoStBean = new ScheduleTblBean(postId);
                        this.AUTO_SCHEDULE_PPT.put(postId, autoStBean);
                    }
                    if ("S".equals(pushSendResultValue.getProperty("RTN_TYPE"))) {
                        if (Integer.parseInt(pushSendResultValue.getProperty("FAIL_CNT")) > 0) {
                            autoStBean.addFailCnt();
                            autoStBean.addErrorCnt(pushSendResultValue.getProperty("ERROR_CODE"));
                        }
                    } else if (pushSendResultValue.getProperty("RTN_TYPE").equals(OPEN_TYPE)) {
                        if (!pushSendResultValue.getProperty("DELIVER_TIME").equals("")) {
                            autoStBean.addOpenCnt();
                        }
                    } else if (pushSendResultValue.getProperty("RTN_TYPE").equals(CLICK_TYPE) && !pushSendResultValue.getProperty("DELIVER_TIME").equals("")) {
                        autoStBean.addClickCnt();
                    }
                    stBean.addPush();
                    continue;
                }
                try {
                    campUpt.update(pushSendResultValue, list_table);
                }
                catch (Exception e) {
                    continue;
                }
                stBean = (ScheduleTblBean)this.CAMP_SCHEDULE_PPT.get(postId);
                if (stBean == null) {
                    stBean = new ScheduleTblBean(postId);
                    this.CAMP_SCHEDULE_PPT.put(postId, stBean);
                }
                if (pushSendResultValue.getProperty("RTN_TYPE").equals("S")) {
                    stBean.addPush();
                    if (Integer.parseInt(pushSendResultValue.getProperty("FAIL_CNT")) <= 0) continue;
                    stBean.addFailCnt();
                    stBean.addErrorCnt(pushSendResultValue.getProperty("ERROR_CODE"));
                    continue;
                }
                if (pushSendResultValue.getProperty("RTN_TYPE").equals(OPEN_TYPE)) {
                    if (pushSendResultValue.getProperty("DELIVER_TIME").equals("")) continue;
                    stBean.addOpenCnt();
                    continue;
                }
                if (!pushSendResultValue.getProperty("RTN_TYPE").equals(CLICK_TYPE) || pushSendResultValue.getProperty("DELIVER_TIME").equals("")) continue;
                stBean.addClickCnt();
            }
            if (this.CAMP_SCHEDULE_PPT.size() > 0) {
                this.schdSummary(this.CAMP_SCHEDULE_PPT, "MASS");
            }
            if (this.AUTO_SCHEDULE_PPT.size() > 0) {
                this.schdSummary(this.AUTO_SCHEDULE_PPT, "AUTO");
            }
        }
        catch (Exception e) {
            log.error("PushUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (modulePushResult != null) {
                modulePushResult.close();
            }
            campUpt.release();
            autoUpt.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schdSummary(Hashtable schdMap, String type) {
        ScheduleTblBean stBean = null;
        StringBuffer buff = new StringBuffer(512);
        int result = 0;
        int summaryCnt = 0;
        try {
            Enumeration e = schdMap.elements();
            while (e.hasMoreElements()) {
                result = 0;
                stBean = (ScheduleTblBean)e.nextElement();
                buff.setLength(0);
                if (log.isDebugEnabled()) {
                    log.debug("[stBean content]\n\t" + stBean.toString());
                }
                if (type.equals("AUTO")) {
                    StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO, stBean.getElement(type), "${", "}", true, false);
                } else {
                    StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, stBean.getElement(type), "${", "}", true, false);
                }
                result = this.MODULE_PUSH_UPDATE_STMT.executeUpdate(buff.toString());
                if (result < 1) {
                    log.debug("[SCHEDULE SUMMARY FAIL]:" + stBean.getName());
                    continue;
                }
                ++summaryCnt;
            }
        }
        catch (Exception exception) {
        }
        finally {
            buff.setLength(0);
            buff = null;
            schdMap.clear();
        }
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return PushUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("PushUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("PushUpdator", (Object)"init error", (Object)thw);
    }
}

