/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jupiter.mass.log.updator.sync.SwitchingFactory;
import jupiter.mass.log.updator.sync.SwitchingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;

public abstract class PushFinishedDelete
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushFinishedDelete.class);
    private eMsPreparedStatement PSTATEMENT = null;
    private eMsStatement TMS_PUSH_SELECT_STMT = null;
    protected String DELETE_PUSH_SENDED_LOG = null;
    protected String SELECT_PUSH_SENDED_LOG_POST_ID = null;
    private static String deleteHour = null;

    public PushFinishedDelete(String name, String id) {
        super((short)2, 2L);
        this.setName(name);
        this.setTaskID(id);
    }

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        deleteHour = tmp.getProperty("delete.hour", "01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        eMsConnection SOURCE_CONNECTION = null;
        eMsResultSet eMsRs = null;
        if (deleteHour.equals(Cal.getHour())) {
            if (log.isDebugEnabled()) {
                log.debug("CALL PushFinishedDelete===> execute()");
            }
            SwitchingService switching = null;
            try {
                switching = SwitchingFactory.getSwitchingFactory().getInstance("push");
                switching.doLock();
                if (log.isDebugEnabled()) {
                    log.debug("=========================== PUSH_SEND_QUE_LOG DELETE START ==============================");
                }
                this.PSTATEMENT = new eMsPreparedStatement(this.DELETE_PUSH_SENDED_LOG, "${", "}");
                this.PSTATEMENT.connectTo(this.getConnection());
                this.TMS_PUSH_SELECT_STMT = this.getConnection().createStatement();
                eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SENDED_LOG_POST_ID, new Properties(), "${", "}");
                List pushPostIdList = this.fromResultSetToList(eMsRs, "");
                if (pushPostIdList.isEmpty()) {
                    return;
                }
                int cnt = 0;
                for (Properties pushPostIdValue : pushPostIdList) {
                    cnt = this.PSTATEMENT.executeUpdate(pushPostIdValue);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("PUSH_SEND_QUE_LOG DELETE POST_ID:" + pushPostIdValue.getProperty("POST_ID") + " CNT :" + cnt);
                }
                if (log.isDebugEnabled()) {
                    log.debug("=========================== PUSH_SEND_QUE_LOG DELETE END ==============================");
                }
                switching.unLock();
            }
            catch (Throwable thw) {
                log.error("CALL execute() ERROR", thw);
            }
            finally {
                try {
                    if (this.PSTATEMENT != null) {
                        this.PSTATEMENT.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.TMS_PUSH_SELECT_STMT != null) {
                        this.TMS_PUSH_SELECT_STMT.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (SOURCE_CONNECTION != null) {
            this.close(SOURCE_CONNECTION);
        }
    }

    public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception {
        ArrayList<Properties> pushResult = new ArrayList<Properties>();
        while (rs.next()) {
            Properties pushSendResultValue = new Properties();
            pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
            rs.putToMap(pushSendResultValue, false);
            pushResult.add(pushSendResultValue);
        }
        return pushResult;
    }

    @Override
    public void execute_initiateError(Throwable thw) {
    }

    @Override
    public void release_Resource() {
    }

    public abstract eMsConnection getConnection() throws Exception;

    public abstract void close(eMsConnection var1);
}

