/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringUtil;

public class PushCampSendListUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushCampSendListUpdator.class);
    private eMsPreparedStatement PSTMT = null;
    private eMsPreparedStatement OPEN_PSTMT = null;
    private eMsPreparedStatement CHECK_PSTMT = null;
    protected eMsConnection SOURCE_CONNECTION = null;
    private eMsStatement TMS_PUSH_SELECT_STMT = null;
    private String SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = null;
    private String QUERY_TARGET_PUSH_POST_ID_QUERY = null;
    private String UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String UPDATE_PUSH_CHECK_FLAG_QUERY = null;
    private String SELECT_PUSH_SEND_QUE_LOG = null;
    private String UPDATE_PUSH_CHECK_FLAG_FINAL = null;
    private String SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = null;
    private String UPDATE_TMS_PUSH_LIST = null;
    private String UPDATE_TMS_CAMP_SEND_OPEN = null;
    private String UPDATE_TMS_CAMP_SEND_CLICK = null;

    public PushCampSendListUpdator() {
        super((short)2, 2L);
        this.setName("PushCampSendListUpdator");
        this.setTaskID("PushCampSendListUpdator");
        this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("MASS_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
        this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
        this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("MASS_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
        this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TARGET_PUSH_COUNT_SUMMARY_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("MASS_UPDATE", "UPDATE_PUSH_CHECK_FLAG_FINAL");
        this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_PUSH_LIST");
        this.UPDATE_TMS_CAMP_SEND_OPEN = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_CAMP_SEND_OPEN");
        this.UPDATE_TMS_CAMP_SEND_CLICK = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_CAMP_SEND_CLICK");
        this.SELECT_PUSH_SEND_QUE_LOG = SqlManager.getQuery("MASS_UPDATE", "SELECT_PUSH_SEND_QUE_LOG");
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampSendListUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("PushCampSendListUpdator", (Object)"CALL execute() ERROR", (Object)thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampSendListUpdator===> execute_init()");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        this.TMS_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampSendListUpdator===> releaseResource()");
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampSendListUpdator===> execute_main()");
        }
        eMsResultSet pushListTableResult = null;
        Properties tValue = new Properties();
        try {
            this.TMS_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
            pushListTableResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            while (pushListTableResult.next()) {
                if (pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", pushListTableResult.getString("LIST_TABLE1").toString());
                    continue;
                }
                pushListTableResult.putToMap(tValue, false);
            }
            if (pushListTableResult != null) {
                pushListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String pushListTable = iter.next().toString();
                if (!pushListTable.equals("") && !pushListTable.equals(null)) {
                    this.update_process(pushListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            }
        }
        catch (Exception e) {
            log.error("PushCampSendListUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (pushListTableResult != null) {
                pushListTableResult.close();
                pushListTableResult = null;
            }
        }
    }

    public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception {
        ArrayList<Properties> pushResult = new ArrayList<Properties>();
        while (rs.next()) {
            Properties pushSendResultValue = new Properties();
            pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
            rs.putToMap(pushSendResultValue, false);
            pushResult.add(pushSendResultValue);
        }
        return pushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        log.debug("PushCampSendListUpdator", (Object)"update_process", (Object)"=========================== MASS SEND LIST UPDATE START ==============================");
        eMsResultSet PushPostIdResult = null;
        eMsResultSet eMsRs = null;
        Properties prePushSendResultValue = new Properties();
        Object stBean = null;
        boolean result = false;
        boolean updateFlag = false;
        StringBuffer buff = new StringBuffer(512);
        try {
            prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
            this.SOURCE_CONNECTION.setAutoCommit(false);
            PushPostIdResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_POST_ID_QUERY, prePushSendResultValue, "${", "}");
            List pushPostIdList = this.fromResultSetToList(PushPostIdResult, list_table);
            if (pushPostIdList.isEmpty()) {
                return;
            }
            int cnt = 0;
            this.SOURCE_CONNECTION.setAutoCommit(false);
            for (Properties pushPostIdValue : pushPostIdList) {
                String post_id = pushPostIdValue.getProperty("POST_ID");
                String push_table = StringUtil.getPushTable(post_id);
                pushPostIdValue.setProperty("PUSH_TABLE", push_table);
                this.UPDATE_TMS_PUSH_LIST = this.UPDATE_TMS_PUSH_LIST.replaceAll("\\$\\{PUSH_TABLE}", push_table);
                this.PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_TMS_PUSH_LIST, "${", "}");
                this.OPEN_PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_TMS_CAMP_SEND_OPEN, "${", "}");
                this.CHECK_PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_PUSH_CHECK_FLAG_FINAL, "${", "}");
                try {
                    eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SEND_QUE_LOG, pushPostIdValue, "${", "}");
                    int listCnt = 0;
                    int openCnt = 0;
                    while (eMsRs.next()) {
                        Properties p = new Properties();
                        eMsRs.putToMap(p, false);
                        p.setProperty("PUSH_TABLE", push_table);
                        listCnt += this.PSTMT.executeUpdateLong(p);
                        if (!p.getProperty("OPEN_CNT", "0").equals("0")) {
                            openCnt += this.OPEN_PSTMT.executeUpdateLong(p);
                        }
                        cnt += this.CHECK_PSTMT.executeUpdateLong(p);
                        if (listCnt % 5000 != 0) continue;
                        log.error("PushCampSendListUpdator", (Object)("POST_ID :" + post_id + " TMS_CAMP_SEND_LIST_ :" + listCnt + " TMS_CAMP_SEND_OPEN :" + openCnt));
                        this.SOURCE_CONNECTION.commit();
                    }
                    log.error("PushCampSendListUpdator", (Object)("POST_ID :" + post_id + " TMS_CAMP_SEND_LIST_ :" + listCnt + " TMS_CAMP_SEND_OPEN :" + openCnt));
                    this.SOURCE_CONNECTION.commit();
                }
                catch (Exception e) {
                    log.error("PushCampSendListUpdator", (Object)"update_process", (Object)e);
                }
            }
            this.SOURCE_CONNECTION.commit();
            this.SOURCE_CONNECTION.setAutoCommit(true);
            log.debug("PushCampSendListUpdator", (Object)"UPDATE_PUSH_CHECK_FLAG_QUERY", (Object)("CHECK_FLAG = '-' -> 'Y' : " + cnt));
            log.debug("PushCampSendListUpdator", (Object)"update_process", (Object)"=========================== MASS SEND LIST UPDATE END ==============================");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("PushCampSendListUpdator", (Object)"update_process", (Object)e);
        }
        finally {
            if (PushPostIdResult != null) {
                PushPostIdResult.close();
                PushPostIdResult = null;
            }
            if (eMsRs != null) {
                eMsRs.close();
                eMsRs = null;
            }
            if (this.PSTMT != null) {
                this.PSTMT.close();
                this.PSTMT = null;
            }
            if (this.OPEN_PSTMT != null) {
                this.OPEN_PSTMT.close();
                this.OPEN_PSTMT = null;
            }
            if (this.CHECK_PSTMT != null) {
                this.CHECK_PSTMT.close();
                this.CHECK_PSTMT = null;
            }
        }
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("PushCampSendListUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("PushCampSendListUpdator", (Object)"init error", (Object)thw);
    }
}

