/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.log.updator.KakaoResultUpdator;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.Tracer;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class KakaoUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(KakaoUpdator.class);
    private static final String _USE_OTHER_DB_ = "use.other.db";
    protected static final String _MASS_ = "MASS";
    protected static final String _AUTO_ = "AUTO";
    protected static final String _TEST_ = "TEST";
    private static String commitInterval = "1000";
    private static String QUERY_SELECT_TARGET_LIST_TABLE = null;
    private static String QUERY_TARGET_KAKAO_RESULT_QUERY = null;
    private static String QUERY_TARGET_FT_RESULT_QUERY = null;
    private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
    private String threadId = null;
    private Map<String, ScheduleTblBean> campSummaryPpp = new HashMap<String, ScheduleTblBean>();
    private Map<String, ScheduleTblBean> autoSummaryPpp = new HashMap<String, ScheduleTblBean>();
    private Map<String, List<Properties>> autoListPpp = new HashMap<String, List<Properties>>();
    private Map<String, List<Properties>> campListPpp = new HashMap<String, List<Properties>>();
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsConnection moduleConnection = null;
    private eMsStatement MODULE_KAKAO_SELECT_STMT = null;
    private eMsStatement TMS_KAKAO_SELECT_STMT = null;
    private eMsStatement BASIC_KAKAO_UPDATE_STMT = null;
    private boolean isUseOtherDb = false;
    private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
    protected List<Properties> AUTO_TARGETLIST = null;
    protected List<Properties> CAMP_TARGETLIST = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setName("KakaoUpdator");
        this.setTaskID("KakaoUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
        this.threadId = this.TASK_PROPERTY.getProperty("THREAD_ID");
        this.isUseOtherDb = Boolean.parseBoolean(this.TASK_PROPERTY.getProperty(_USE_OTHER_DB_));
    }

    @Override
    public void execute() {
        log.info("{}_{} CALL KakaoUpdator===> execute()", (Object)this.getName(), (Object)this.threadId);
        try {
            log.debug("{}_{} CALL KakaoUpdator===> execute_init start", (Object)this.getName(), (Object)this.threadId);
            this.execute_init();
            log.debug("{}_{} CALL KakaoUpdator===> execute_init done", (Object)this.getName(), (Object)this.threadId);
            log.debug("{}_{} CALL KakaoUpdator===> execute_main start", (Object)this.getName(), (Object)this.threadId);
            this.execute_main();
            log.debug("{}_{} CALL KakaoUpdator===> execute_main done", (Object)this.getName(), (Object)this.threadId);
        }
        catch (Throwable thw) {
            log.error("KakaoUpdator", (Object)"CALL execute() ERROR", (Object)thw);
            thw.printStackTrace();
        }
        finally {
            log.debug("{}_{} CALL KakaoUpdator===> releaseResource start", (Object)this.getName(), (Object)this.threadId);
            this.releaseResource();
            log.debug("{}_{} CALL KakaoUpdator===> releaseResource done", (Object)this.getName(), (Object)this.threadId);
        }
    }

    protected String getMonthListTableName(String month, String type) {
        String string = month = month.length() == 1 ? "0" + month : month;
        if (type.equals(_AUTO_)) {
            return "TMS_AUTO_SEND_LIST_" + month;
        }
        return "TMS_CAMP_SEND_LIST_" + month;
    }

    protected void execute_init() throws Throwable {
        log.debug("{}_{} CALL KakaoUpdator===> execute_init()", (Object)this.getName(), (Object)this.threadId);
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        this.moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
        this.TMS_KAKAO_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.BASIC_KAKAO_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_KAKAO_SELECT_STMT = this.moduleConnection.createStatement();
    }

    protected void releaseResource() {
        log.debug("{}_{} CALL KAKAOUpdator===> releaseResource()", (Object)this.getName(), (Object)this.threadId);
        if (this.SOURCE_CONNECTION != null) {
            if (this.TMS_KAKAO_SELECT_STMT != null) {
                this.SOURCE_CONNECTION.recycleStatement(this.TMS_KAKAO_SELECT_STMT);
            }
            if (this.BASIC_KAKAO_UPDATE_STMT != null) {
                this.SOURCE_CONNECTION.recycleStatement(this.BASIC_KAKAO_UPDATE_STMT);
            }
            try {
                this.SOURCE_CONNECTION.commit();
                this.SOURCE_CONNECTION.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.moduleConnection != null) {
            if (this.MODULE_KAKAO_SELECT_STMT != null) {
                this.moduleConnection.recycleStatement(this.MODULE_KAKAO_SELECT_STMT);
            }
            try {
                this.moduleConnection.commit();
                this.moduleConnection.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.moduleConnection.recycle();
        }
    }

    protected void execute_main() throws Throwable {
        log.debug("{}_{} CALL KAKAOUpdator===> execute_main()", (Object)this.getName(), (Object)this.threadId);
        this.updateProcess(this.TASK_PROPERTY.getProperty("SMS_LIST_TABLE", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcess(String list_table) {
        Properties kakaoSendResultValue = new Properties();
        String maxId = "";
        String minId = "";
        try (eMsResultSet moduleKakaoResult = null;){
            this.SOURCE_CONNECTION.setAutoCommit(false);
            if (this.moduleConnection != null) {
                this.moduleConnection.setAutoCommit(false);
            }
            maxId = this.TASK_PROPERTY.getProperty("MAX_ID");
            minId = this.TASK_PROPERTY.getProperty("MIN_ID");
            commitInterval = this.TASK_PROPERTY.getProperty("CHECK_INTERVAL");
            kakaoSendResultValue.setProperty("LIST_TABLE", list_table);
            kakaoSendResultValue.setProperty("MAX_ID", maxId);
            kakaoSendResultValue.setProperty("MIN_ID", minId);
            moduleKakaoResult = list_table.startsWith("IMC_FT_BIZ_MSG_LOG") ? this.MODULE_KAKAO_SELECT_STMT.executeQuery(QUERY_TARGET_FT_RESULT_QUERY, kakaoSendResultValue, "${", "}") : this.MODULE_KAKAO_SELECT_STMT.executeQuery(QUERY_TARGET_KAKAO_RESULT_QUERY, kakaoSendResultValue, "${", "}");
            while (moduleKakaoResult.next()) {
                String postId;
                Properties resultProp = new Properties();
                moduleKakaoResult.putToMap(resultProp, false);
                String sendType = resultProp.getProperty("SEND_TYPE", _AUTO_);
                resultProp.setProperty("AGENT_TABLE", list_table);
                log.debug("======== resultProp : {}   listTable : {}", (Object)resultProp.toString(), (Object)list_table);
                if (sendType.equals(_AUTO_)) {
                    postId = resultProp.getProperty("POST_ID", "").trim();
                    String workday = postId.split("_")[0].trim();
                    String seqno = postId.split("_")[1].trim();
                    String tempMemberId = resultProp.getProperty("MEMBER_ID");
                    int posMid = tempMemberId.lastIndexOf("_");
                    String mId = tempMemberId.substring(0, posMid).trim();
                    String mIdSeq = tempMemberId.substring(posMid + 1).trim();
                    resultProp.setProperty("WORKDAY", workday);
                    resultProp.setProperty("SEQNO", seqno);
                    resultProp.setProperty("MEMBER_ID", mId);
                    resultProp.setProperty("MEMBER_ID_SEQ", mIdSeq);
                    if ("".equals(postId) || "".equals(workday) || "".equals(seqno) || "".equals(tempMemberId)) {
                        log.debug("Data is invalid skip...AUTO UPDATE PARAM: {}", (Object)resultProp);
                        continue;
                    }
                    String listTable = resultProp.getProperty("LIST_TABLE", "").trim();
                    List<Properties> autoList = this.autoListPpp.get(listTable);
                    if (autoList == null) {
                        autoList = new ArrayList<Properties>();
                        this.autoListPpp.put(listTable, autoList);
                    }
                    autoList.add(resultProp);
                    ScheduleTblBean autoBean = this.autoSummaryPpp.get(postId);
                    if (autoBean == null) {
                        autoBean = new ScheduleTblBean(postId);
                        this.autoSummaryPpp.put(postId, autoBean);
                    }
                    int failCnt = Integer.parseInt(resultProp.getProperty("FAIL_CNT", "0"));
                    int switchedCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_CNT", "0"));
                    int switchedFailCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_FAIL_CNT", "0"));
                    if (failCnt > 0) {
                        autoBean.addFailCnt();
                        autoBean.addErrorCnt(resultProp.getProperty("ERROR_CODE", ""));
                    }
                    if (switchedCnt > 0) {
                        autoBean.addSwitchedCnt();
                    }
                    if (switchedFailCnt > 0) {
                        autoBean.addSwitchedFailCnt();
                    }
                    autoBean.addPush();
                    continue;
                }
                if (sendType.equals(_MASS_)) {
                    postId = resultProp.getProperty("POST_ID", "").trim();
                    if ("".equals(postId)) {
                        log.debug("Data is invalid skip... MASS UPDATE PARAM : {}", (Object)resultProp);
                        continue;
                    }
                    String listTable = resultProp.getProperty("LIST_TABLE", "").trim();
                    log.debug("======== resultProp : {}   listTable : {}", (Object)resultProp.toString(), (Object)listTable);
                    List<Properties> campList = this.campListPpp.get(listTable);
                    if (campList == null) {
                        campList = new ArrayList<Properties>();
                        this.campListPpp.put(listTable, campList);
                    }
                    campList.add(resultProp);
                    ScheduleTblBean campBean = this.campSummaryPpp.get(postId);
                    if (campBean == null) {
                        campBean = new ScheduleTblBean(postId);
                        this.campSummaryPpp.put(postId, campBean);
                    }
                    int failCnt = Integer.parseInt(resultProp.getProperty("FAIL_CNT", "0"));
                    int switchedCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_CNT", "0"));
                    int switchedFailCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_FAIL_CNT", "0"));
                    if (failCnt > 0) {
                        campBean.addFailCnt();
                        campBean.addErrorCnt(resultProp.getProperty("ERROR_CODE", ""));
                    }
                    if (switchedCnt > 0) {
                        campBean.addSwitchedCnt();
                    }
                    if (switchedFailCnt > 0) {
                        campBean.addSwitchedFailCnt();
                    }
                    campBean.addPush();
                    continue;
                }
                if (sendType.equals(_TEST_)) {
                    log.debug("[TEST] sended test data : {}", (Object)resultProp);
                    continue;
                }
                log.debug("[ERROR] not update target data : {}", (Object)resultProp);
            }
            log.debug("{}_{} update_process while end autoListPpp {} campListPpp {} campSummaryPpp {} autoSummaryPpp {}", new Object[]{this.getName(), this.threadId, this.autoListPpp.size(), this.campListPpp.size(), this.campSummaryPpp.size(), this.autoSummaryPpp.size()});
            if (this.autoListPpp.size() > 0) {
                this.listUpdate(_AUTO_, this.autoListPpp);
            }
            if (this.campListPpp.size() > 0) {
                this.listUpdate(_MASS_, this.campListPpp);
            }
            if (this.campSummaryPpp.size() > 0) {
                this.schdSummary(_MASS_, this.campSummaryPpp);
            }
            if (this.autoSummaryPpp.size() > 0) {
                this.schdSummary(_AUTO_, this.autoSummaryPpp);
            }
        }
    }

    private void schdSummary(String type, Map<String, ScheduleTblBean> schdMap) {
        StringBuffer buff = new StringBuffer(512);
        try {
            for (Map.Entry<String, ScheduleTblBean> target : schdMap.entrySet()) {
                buff.setLength(0);
                ScheduleTblBean stBean = target.getValue();
                log.debug("{}_{} summary stBean data: {}", new Object[]{this.getName(), this.threadId, stBean.toString()});
                String targetQuery = type.equals(_AUTO_) ? QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO : QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY;
                StringConvertUtil.ConvertString(buff, targetQuery, stBean.getElement(type), "${", "}", true, false);
                if (this.BASIC_KAKAO_UPDATE_STMT.executeUpdate(buff.toString()) >= 1) continue;
                log.debug("{}_{} schedule summary fail: {}", new Object[]{this.getName(), this.threadId, stBean.getName()});
            }
        }
        catch (Exception e) {
            log.error("ERROR schdSummary... ", (Throwable)e);
        }
    }

    private void listUpdate(String type, Map<String, List<Properties>> targetList) {
        StringBuffer buff = new StringBuffer(512);
        log.debug("Taget Type is {}", (Object)type);
        try {
            log.info("{}_{} update_process listUpdate start, commit Interval : {} ", new Object[]{this.getName(), this.threadId, commitInterval});
            for (Map.Entry<String, List<Properties>> target : targetList.entrySet()) {
                buff.setLength(0);
                String listTable = target.getKey();
                List<Properties> targetListData = target.getValue();
                KakaoResultUpdator resultUpdator = new KakaoResultUpdator();
                resultUpdator.init(commitInterval);
                resultUpdator.update(targetListData, listTable, type);
                resultUpdator.moduleUpdate(targetListData);
                resultUpdator.release();
            }
        }
        catch (Exception e) {
            log.error("ERROR UpdateError... ", (Throwable)e);
        }
        log.info("{}_{} update_process listUpdate end ", (Object)this.getName(), (Object)this.threadId);
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return KakaoUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("KAKAOUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        Tracer.error("KAKAOUpdator", "init error", thw);
    }

    static {
        QUERY_TARGET_KAKAO_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_KAKAO_RESULT_QUERY");
        QUERY_TARGET_FT_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_FT_RESULT_QUERY");
        QUERY_SELECT_TARGET_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_LIST_TABLE");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
        moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

