/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import jupiter.mass.log.updator.KakaoUpdator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

public class KakaoResultUpdator
extends KakaoUpdator {
    private static final Logger log = LoggerFactory.getLogger(KakaoResultUpdator.class);
    private static final String CHECK_FLAG = "UPDATE_CHECK_FLAG";
    private static final String FAIL = "F";
    private static final String OK = "Y";
    private static final String ING_MSG = "S";
    private static int commit = 1000;
    private static String queryAutoUpdateSendList = null;
    private static String queryMassUpdateSendList = null;
    private static String queryUpdateLog = null;
    private static String queryUpdateLogBasic = null;
    private eMsConnection oriConnection = null;
    private eMsConnection moduleConnection = null;
    private eMsPreparedStatement oriPsSendList = null;
    private eMsPreparedStatement modulePsLog = null;
    private static ConnectInfo moduleConnectionInformation = new ConnectInfo();

    public void init(String commitInterval) {
        try {
            this.oriConnection = ConnectionPool.getConnection();
            this.moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
            commit = Integer.parseInt(commitInterval);
        }
        catch (Exception e) {
            log.error("ERROR init()... {}", (Throwable)e);
        }
    }

    public void update(List<Properties> resultPropList, String listTable, String sendType) throws Exception {
        block4: {
            try {
                StringBuffer buff = new StringBuffer(512);
                buff.setLength(0);
                log.debug("[{}] update kakao Msg : list_table : {}", (Object)sendType, (Object)listTable);
                String targetQuery = sendType.equals("AUTO") ? queryAutoUpdateSendList : queryMassUpdateSendList;
                targetQuery = this.ppsParseSQL(targetQuery, "LIST_TABLE", listTable, "@{", "}");
                targetQuery = this.ppsParseSQL(targetQuery, "PK_INDEX", listTable.replace("TMS_", "PK_"), "@{", "}");
                log.debug("Update Send List Query: {}", (Object)targetQuery);
                this.oriConnection.setAutoCommit(false);
                this.oriPsSendList = this.oriConnection.prepareStatement(targetQuery, "${", "}");
                int commitCnt = 0;
                for (Properties resultProp : resultPropList) {
                    this.oriPsSendList.addBatch(resultProp);
                    if (++commitCnt % commit != 0) continue;
                    this.oriPsSendList.executeBatch();
                    this.oriConnection.commit();
                    log.debug("{} commited", (Object)targetQuery);
                }
                this.oriPsSendList.executeBatch();
                this.oriConnection.commit();
            }
            catch (Exception e) {
                this.oriConnection.rollback();
                for (Properties resultProp : resultPropList) {
                    this.updateOne(resultProp, sendType);
                }
                if (!(e instanceof SQLException)) break block4;
                throw e;
            }
        }
    }

    public void moduleUpdate(List<Properties> resultPropList) throws Exception {
        try {
            this.moduleConnection.setAutoCommit(false);
            log.debug("queryUpdateLog: {}", (Object)queryUpdateLog);
            queryUpdateLog = this.ppsParseSQL(queryUpdateLogBasic, "AGENT_TABLE", resultPropList.get(0).getProperty("AGENT_TABLE"), "@{", "}");
            this.modulePsLog = this.moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
            log.debug("Update module List Query: {}", (Object)queryUpdateLog);
            int commitCnt = 0;
            for (Properties resultProp : resultPropList) {
                resultProp.setProperty(CHECK_FLAG, OK);
                log.debug("get Id : {}", (Object)resultProp.getProperty("ID"));
                this.modulePsLog.addBatch(resultProp);
                if (++commitCnt % commit != 0) continue;
                this.modulePsLog.executeBatch();
                this.moduleConnection.commit();
                log.debug("{} 1000 commited", (Object)queryUpdateLog);
            }
            this.modulePsLog.executeBatch();
            this.moduleConnection.commit();
        }
        catch (Exception e) {
            this.moduleConnection.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOne(Properties resultProp, String sendType) throws Exception {
        try {
            String listTableName;
            resultProp.setProperty(CHECK_FLAG, OK);
            if (!resultProp.getProperty("ERROR_CODE").equals("01") && !resultProp.getProperty("SMS_TYPE", "").equals("NO")) {
                resultProp.setProperty(CHECK_FLAG, ING_MSG);
            }
            if ("".equals(listTableName = resultProp.getProperty("LIST_TABLE", ""))) {
                log.debug("LIST_TABLE is null... update skip... {}", (Object)resultProp);
                return;
            }
            String targetQuery = sendType.equals("AUTO") ? queryAutoUpdateSendList : queryMassUpdateSendList;
            targetQuery = this.ppsParseSQL(targetQuery, "LIST_TABLE", listTableName, "@{", "}");
            log.debug("Update Send List Query: {}", (Object)targetQuery);
            this.oriPsSendList = this.oriConnection.prepareStatement(targetQuery, "${", "}");
            this.modulePsLog = this.moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
            this.oriPsSendList.executeUpdate(resultProp);
            this.modulePsLog.executeUpdate(resultProp);
        }
        catch (Exception e) {
            resultProp.setProperty(CHECK_FLAG, FAIL);
            try {
                this.modulePsLog.executeUpdate(resultProp);
            }
            catch (Exception ee) {
                try {
                    this.oriConnection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.moduleConnection != null) {
                    try {
                        this.moduleConnection.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw ee;
            }
            log.error("ERROR update...", (Throwable)e);
            if (e instanceof SQLException) {
                throw e;
            }
        }
        finally {
            if (this.oriPsSendList != null) {
                this.oriConnection.recycleStatement(this.oriPsSendList);
            }
            if (this.modulePsLog != null) {
                this.moduleConnection.recycleStatement(this.modulePsLog);
            }
        }
    }

    public void release() {
        if (this.oriPsSendList != null) {
            this.oriConnection.recycleStatement(this.oriPsSendList);
        }
        if (this.modulePsLog != null) {
            this.moduleConnection.recycleStatement(this.modulePsLog);
        }
        if (this.oriConnection != null) {
            try {
                this.oriConnection.commit();
                this.oriConnection.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.oriConnection.recycle();
        }
        if (this.moduleConnection != null) {
            try {
                this.moduleConnection.commit();
                this.moduleConnection.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.moduleConnection.recycle();
        }
    }

    static {
        queryAutoUpdateSendList = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_SEND_LIST_N");
        queryMassUpdateSendList = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_SEND_LIST_N");
        queryUpdateLog = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
        queryUpdateLogBasic = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
        moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

