/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Properties;
import jupiter.mass.log.updator.AddBatch;
import jupiter.mass.log.updator.AddBatchIterator;
import jupiter.mass.log.updator.TmsAddBatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

public class DefaultAddBatch
implements AddBatch<TmsAddBatchInfo> {
    private static final Logger log = LoggerFactory.getLogger(DefaultAddBatch.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TmsAddBatchInfo ab) throws Exception {
        int insertedCount = 0;
        int count = 0;
        int failCount = 0;
        eMsPreparedStatement ps = null;
        eMsConnection conn = null;
        AddBatchIterator rs = null;
        try {
            conn = ab.getConnection();
            conn.setAutoCommit(false);
            ps = ab.getConnection().prepareStatement(ab.getQuery(), "${", "}");
            rs = ab.getAddBatchIterator();
            while (rs.next()) {
                Properties p = new Properties();
                try {
                    rs.putData(p);
                    ps.addBatch(p);
                    if (count % ab.getCommitCount() == 0) {
                        insertedCount += DefaultAddBatch.batchResultCountValidation(ps.executeBatch());
                    }
                }
                catch (Exception e) {
                    log.error("PushCampUpdator pushSendLogToTmsRepository", (Throwable)e);
                    ab.setErrorInfo("count[" + count + "] info[" + p.toString() + "]");
                    e.printStackTrace();
                }
                ++count;
            }
            failCount = count - (insertedCount += DefaultAddBatch.batchResultCountValidation(ps.executeBatch()));
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Exception e) {
            ab.setErrorInfo("count[" + count + "] info[" + e.toString() + "]");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        ab.setFailCount(failCount);
        ab.setSuccessCount(insertedCount);
        if (ab.isFinallyConnectionClose()) {
            conn.close();
        }
    }

    private static int batchResultCountValidation(int[] updates) {
        int tmpCnt = 0;
        for (int i = 0; i < updates.length; ++i) {
            if (updates[i] == -2) {
                ++tmpCnt;
                continue;
            }
            if (updates[i] == -3) {
                log.error("Push Result Insert Fail Position[" + i + "]");
                continue;
            }
            tmpCnt += updates[i];
        }
        return tmpCnt;
    }
}

