/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.actor;

import com.humuson.tms.constrants.CommonType;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.actor.AbstractSingleRcptCommunicationActor;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class LmsFixedDomainSingleRcptBufferedCommunicationActor
extends AbstractSingleRcptCommunicationActor {
    private static final Logger log = LoggerFactory.getLogger(LmsFixedDomainSingleRcptBufferedCommunicationActor.class);
    private static final String SEND_TYPE = "SEND_TYPE";
    private static final String POST_ID = "POST_ID";
    private static final String TO_NUMBER = "TO_NUMBER";
    private static final String FROM_NUMBER = "FROM_NUMBER";
    private static String encYn = null;
    private static String encKey = null;
    private static String smsModuleName = null;
    private static boolean smsDbUse = false;
    public static String queryInsertLmsSend = null;
    private static int th_cnt = 0;
    private static ConnectInfo moduleConnectionInfo = null;
    private String errorMessage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void work() throws Exception {
        ++LmsFixedDomainSingleRcptBufferedCommunicationActor.th_cnt;
        emsConnection = null;
        pstmt = null;
        emsConnection = LmsFixedDomainSingleRcptBufferedCommunicationActor.smsDbUse != false ? ConnectionPool.getConnection(LmsFixedDomainSingleRcptBufferedCommunicationActor.moduleConnectionInfo) : ConnectionPool.getConnection();
        pstmt = emsConnection.prepareStatement(LmsFixedDomainSingleRcptBufferedCommunicationActor.queryInsertLmsSend, "${", "}");
        this.CURR_STEP = (short)-1;
        memberHash = null;
        while (true) lbl-1000:
        // 7 sources

        {
            if (this.RCPT_TO == null) {
                this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
            }
            if (this.RCPT_TO == null) {
                return;
            }
            if (LmsFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) {
                this.log("pop up:" + this.RCPT_TO.toString());
            }
            if (this.splitRcptInfo() == null) {
                if (!LmsFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) continue;
                this.log("split fail continue");
                continue;
            }
            LmsFixedDomainSingleRcptBufferedCommunicationActor.log.debug("LMS 1TO1 - START : [th_cnt]: {} / [size]: {}", (Object)LmsFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, (Object)this.PARSED_RCPT_INFO.size());
            i = false;
            try {
                emsConnection.setAutoCommit(false);
                time = System.currentTimeMillis();
                while (this.PARSED_RCPT_INFO.size() > 0) {
                    nextSpool = this.PARSED_RCPT_INFO.removeFirst();
                    if (!this.parseRcptInfo(nextSpool)) {
                        if (!LmsFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) continue;
                        this.log("parseRcptInfo fail continue");
                        continue;
                    }
                    if (this.connection_delay > 0) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.connection_delay);
                        }
                        catch (Exception var8_9) {
                            // empty catch block
                        }
                    }
                    this.start_process(this.RCPT_ARRAY);
                    try {
                        memberHash = this.setMapping(this.RCPT_ARRAY);
                        if (LmsFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) {
                            LmsFixedDomainSingleRcptBufferedCommunicationActor.log.debug("MEMBER HASH: {}", memberHash);
                        }
                        if (pstmt.executeUpdate(memberHash) > 0) {
                            this.success_process(this.RCPT_ARRAY);
                            continue;
                        }
                        this.error_process(this.RCPT_ARRAY);
                    }
                    catch (Exception e) {
                        this.errorMessage = e.toString();
                        this.error_process(this.RCPT_ARRAY);
                        LmsFixedDomainSingleRcptBufferedCommunicationActor.log.error("LMS INSERT ERROR", (Throwable)e);
                    }
                    finally {
                        memberHash.clear();
                    }
                }
                if (!LmsFixedDomainSingleRcptBufferedCommunicationActor.log.isDebugEnabled()) ** GOTO lbl-1000
                LmsFixedDomainSingleRcptBufferedCommunicationActor.log.debug("LMS 1TO1 - END : [th_cnt]: {} / [size]: {} / [loop_time]: {}", new Object[]{LmsFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, this.PARSED_RCPT_INFO.size(), System.currentTimeMillis() - time + "ms"});
            }
            catch (Exception e) {
                emsConnection.rollback();
                LmsFixedDomainSingleRcptBufferedCommunicationActor.log.error("LMS 1TO1 - ROLLBACK!!! LMS \ub4f1\ub85d \uc624\ub958", (Throwable)e);
            }
            finally {
                if (emsConnection == null) continue;
                LmsFixedDomainSingleRcptBufferedCommunicationActor.log.debug("LMS 1TO1 - COMMIT TRUE : [th_cnt]: {} / [size]: {}", (Object)LmsFixedDomainSingleRcptBufferedCommunicationActor.th_cnt, (Object)this.PARSED_RCPT_INFO.size());
                emsConnection.commit();
                emsConnection.setAutoCommit(true);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
            if (emsConnection != null) {
                emsConnection.destroy();
            }
        }
    }

    @Override
    protected void success_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "54", "10", "250 LMS Message accepted for send", (short)2);
    }

    @Override
    protected void error_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "LMS fail " + this.errorMessage, this.sendState.getLogLevel());
    }

    public Map<String, String> setMapping(String[] array) throws Exception {
        String sendType = null;
        String postId = null;
        String memberId = null;
        String toNumber = null;
        String content = null;
        String listTable = null;
        String rowId = null;
        HashMap<String, String> memberHash = new HashMap<String, String>();
        try {
            sendType = array[0];
            postId = array[1];
            memberId = array[2];
            content = array[4];
            listTable = array[10];
            rowId = array[12];
            if (encYn.equals("Y")) {
                toNumber = array[11];
                if (encKey.equals("")) {
                    memberHash.put(TO_NUMBER, CryptoUtil.decrypt(toNumber, "TELNO_ENCR"));
                } else {
                    memberHash.put(TO_NUMBER, CryptoUtil.decrypt(toNumber, "TELNO_ENCR", encKey));
                }
            } else {
                toNumber = array[3];
                memberHash.put(TO_NUMBER, toNumber);
            }
            memberHash.put(POST_ID, postId);
            memberHash.put("MEMBER_ID", memberId);
            memberHash.put("CONTENT", content);
            memberHash.put("LIST_TABLE", listTable);
            memberHash.put("ROW_ID", rowId);
            ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(postId);
            Properties scheduleInfoProp = sendContentInfo.getScheduleInfo();
            String sendState = scheduleInfoProp.getProperty("SEND_STATE", "");
            if (sendState.equals("TEST") || sendState.equals("WFTEST")) {
                memberHash.put(SEND_TYPE, CommonType.TEST.getCode());
            } else if (postId.indexOf("_") > -1 || sendType.equals("AUTORESEND")) {
                memberHash.put(SEND_TYPE, CommonType.AUTO.getCode());
            } else {
                memberHash.put(SEND_TYPE, CommonType.CAMP.getCode());
            }
            StringBuffer buffer = new StringBuffer(512);
            Enumeration<?> eNum = scheduleInfoProp.propertyNames();
            while (eNum.hasMoreElements()) {
                String key = eNum.nextElement().toString();
                String value = scheduleInfoProp.getProperty(key);
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, value, this._MEMBER_HASH_, "${", "}", true, false);
                if (key.equals("CONTENT") || memberHash.containsKey(key)) continue;
                memberHash.put(key, StringUtil.trimNull(buffer));
            }
            memberHash.put(FROM_NUMBER, scheduleInfoProp.getProperty(FROM_NUMBER, ""));
            memberHash.put("USER_ID", scheduleInfoProp.getProperty("USER_ID", ""));
            memberHash.put("USER_DEPT", scheduleInfoProp.getProperty("USER_DEPT", ""));
            memberHash.put("SMS_ID", scheduleInfoProp.getProperty("SMS_ID", ""));
            return memberHash;
        }
        catch (Exception e) {
            log.error("ERROR setMapping.", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void all_error_process() {
        this.error_process(this.RCPT_ARRAY);
        this.parsedListAllErrorProcess();
    }

    static {
        encYn = eMsSystem.getProperty("member.info.encrypt.yn", "N");
        encKey = eMsSystem.getProperty("member.info.encrypt.key", "");
        smsModuleName = eMsSystem.getProperty("sms.module.name", "imc");
        smsDbUse = Boolean.parseBoolean(eMsSystem.getProperty("sms.db.use", "false"));
        queryInsertLmsSend = SqlManager.getQuery("IMC", "QUERY_INSERT_LMS_SEND");
        if (smsDbUse) {
            moduleConnectionInfo = new ConnectInfo();
            moduleConnectionInfo.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
            moduleConnectionInfo.setDB_URL(eMsSystem.getProperty("sms.db.url"));
            moduleConnectionInfo.setDB_UID(eMsSystem.getProperty("sms.db.id"));
            moduleConnectionInfo.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
            moduleConnectionInfo.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
            moduleConnectionInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
            moduleConnectionInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
            moduleConnectionInfo.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
        }
    }
}

