/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.actor;

import java.util.concurrent.atomic.AtomicInteger;
import jupiter.common.actor.BufferedCommunicationActor;
import jupiter.common.communicator.SmtpCommunicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.ErrorSpoolLogger;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;
import pluto.util.recycle.BufferBin;
import pluto.util.recycle.Bufferable;
import venus.spool.common.parser.MultiSpoolTokenizer;
import venus.spool.common.parser.SpoolAnalyzer;

public abstract class AbstractBufferedCommunicationActor
extends SmtpCommunicator
implements BufferedCommunicationActor,
Bufferable {
    private static final Logger log = LoggerFactory.getLogger(AbstractBufferedCommunicationActor.class);
    public static final int RCPT_CONTAIN_LIMIT = 5;
    public static final String PARSING_RESULT_OK = "OK";
    public static final String PARSING_RESULT_CONTENT_INFO_FAIL = "UNREGIST CONTENT INFO";
    protected String[] RCPT_ARRAY = new String[16];
    protected BufferBin INNER_BUFFERED_BIN = null;
    protected boolean alive = false;
    private Thread inner_worker = null;
    protected int connection_delay = 0;
    protected int rset_count = 10;
    protected PlutoLinkedList PARSED_RCPT_INFO = new PlutoLinkedList();
    protected MultiSpoolTokenizer RCPT_INFO_TOKEN = new MultiSpoolTokenizer("<*>");
    protected SpoolAnalyzer SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
    protected static AtomicInteger totalSendCount = new AtomicInteger(0);
    protected static Integer spareMinute = 0;

    public AbstractBufferedCommunicationActor() throws Exception {
        super(false);
    }

    @Override
    public void setBufferBin(BufferBin bin) {
        this.INNER_BUFFERED_BIN = bin;
    }

    @Override
    public void setParameter(BufferBin bin, ThreadGroup group, int name_idx, Integer inter_delay, int rset) {
        String name = bin.getName() + "_Worker_" + String.valueOf(name_idx);
        this.setBufferBin(bin);
        this.setName(name);
        int n = this.connection_delay = inter_delay == null ? 0 : inter_delay;
        if (log.isDebugEnabled()) {
            log.debug(name + "=>INIT ORG SLEEP VALUE:" + inter_delay);
            log.debug(name + "=>INIT CONVERT SLEEP VALUE:" + this.connection_delay);
        }
        this.rset_count = rset;
        this.AGENT_IDX = name_idx;
        this.inner_worker = new Thread(group, this, name);
    }

    @Override
    public void execute() {
        this.inner_worker.start();
    }

    @Override
    public void destroy() {
        log.error(" Call destroy Method... from : " + Thread.currentThread().getName());
        this.clean();
        this.INNER_BUFFERED_BIN.destroy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnd() {
        log.error(" Call setEnd Method... from : " + Thread.currentThread().getName());
        this.alive = false;
        AbstractBufferedCommunicationActor abstractBufferedCommunicationActor = this;
        synchronized (abstractBufferedCommunicationActor) {
            this.notifyAll();
        }
    }

    @Override
    public void setDomain(String domain) {
    }

    @Override
    public void clean() {
        this.sendState.reset();
        this.domain = null;
        this.RCPT_TO = null;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.alive = true;
        AbstractBufferedCommunicationActor abstractBufferedCommunicationActor = this;
        synchronized (abstractBufferedCommunicationActor) {
            this.notifyAll();
        }
        while (this.alive) {
            int bufferSize = this.INNER_BUFFERED_BIN.getBufferSize();
            log.debug("getBufferSize()... bufferSize: {}", (Object)bufferSize);
            if (bufferSize < 1) {
                log.debug("Buffer is empty...");
                spareMinute = 0;
                totalSendCount = new AtomicInteger(0);
            }
            while (this.RCPT_TO == null && this.alive) {
                this.RCPT_TO = this.INNER_BUFFERED_BIN.popup();
            }
            if (this.RCPT_TO == null) continue;
            try {
                this.work();
            }
            catch (Throwable error) {
                log.error(" is catch Throwable : " + error.toString());
                this.log(StringConvertUtil.exToString(this.getName(), error));
                this.sendState.set(error.toString(), "99");
                this.all_error_process();
                if (error instanceof ThreadDeath) {
                    this.alive = false;
                }
            }
            finally {
                this.closeConnection();
            }
            if (this.alive) continue;
            break;
        }
        this.log(this.getName() + " is die....");
        this.destroy();
    }

    @Override
    public void log(String log) {
        this.INNER_BUFFERED_BIN.log(log);
    }

    protected abstract void all_success_process();

    protected void success_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "54", "10", this.sendState.getMESSAGE(), (short)2, this.sendState.getMGS_SEQ());
    }

    protected void start_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "54", "00", "250 Start", (short)1, this.sendState.getMGS_SEQ());
    }

    protected void error_process(String[] _AGENT_ARRAY_) {
        this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), this.sendState.getMESSAGE(), this.sendState.getLogLevel(), this.sendState.getMGS_SEQ());
    }

    protected boolean parseMemberInfoOnly(Object target) {
        try {
            this.SPOOL_ANALYZER.parse(target.toString());
            this.RCPT_ARRAY[0] = this.SPOOL_ANALYZER.getSendType();
            this.RCPT_ARRAY[1] = this.SPOOL_ANALYZER.getPostID();
            this.RCPT_ARRAY[2] = this.SPOOL_ANALYZER.getMemberID();
            this.RCPT_ARRAY[9] = this.SPOOL_ANALYZER.getStep();
            this.RCPT_ARRAY[3] = this.SPOOL_ANALYZER.getTokenID();
            this.RCPT_ARRAY[7] = this.SPOOL_ANALYZER.getDomain();
            this.RCPT_ARRAY[10] = this.SPOOL_ANALYZER.getListTable();
            this.RCPT_ARRAY[11] = this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT");
            this.SPOOL_ANALYZER.setStep(this.SPOOL_ANALYZER.getIntStep() + 1);
            this.RCPT_ARRAY[5] = this.SPOOL_ANALYZER.isNextSpoolValid() ? this.SPOOL_ANALYZER.compose() : null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error(target.toString(), (Throwable)e);
            }
            this.log("error=>".concat(StringConvertUtil.exToString(e)));
            this.RCPT_ARRAY[6] = e.toString();
            ErrorSpoolLogger.put(target.toString().concat(" =>").concat(e.toString()));
            return false;
        }
        return true;
    }

    protected String splitRcptInfo() {
        try {
            String NEXT;
            this.RCPT_INFO_TOKEN.parse(this.RCPT_TO.toString());
            this.PARSED_RCPT_INFO.clear();
            while (this.RCPT_INFO_TOKEN.hasMoreTokens()) {
                NEXT = this.RCPT_INFO_TOKEN.nextToken();
                if (NEXT.trim().length() < 1) continue;
                this.PARSED_RCPT_INFO.add(NEXT);
            }
            if (this.PARSED_RCPT_INFO.size() == 0) {
                NEXT = null;
                return NEXT;
            }
            NEXT = this.RCPT_INFO_TOKEN.getDomain();
            return NEXT;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error(this.RCPT_TO.toString(), (Throwable)e);
            }
            ErrorSpoolLogger.put(this.RCPT_TO.toString().concat(" =>").concat(e.toString()));
            String string = null;
            return string;
        }
        finally {
            this.RCPT_TO = null;
        }
    }

    protected abstract void work() throws Exception;

    protected abstract void all_start_process();

    protected abstract void all_error_process();
}

