/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import java.util.Iterator;
import java.util.List;
import jupiter.common.actor.ListMaker;
import jupiter.common.task.AbstractDBMailSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.log.SmtpLogger;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public abstract class CommonStepMailSendTask
extends AbstractDBMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(CommonStepMailSendTask.class);
    protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;

    public CommonStepMailSendTask() throws Exception {
        this(1, 60000L);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public CommonStepMailSendTask(short type) throws Exception {
        this(type, 60000L);
    }

    public CommonStepMailSendTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    @Override
    protected void execute_ListMake() throws Exception {
        ListMaker targetMaker = (ListMaker)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)6);
        targetMaker.process(this.TASK_PROPERTY);
    }

    protected void updateTaskState(String __TYPE__, String __STATE__) {
        this.updateTaskState(__TYPE__, __STATE__, "StateUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
        Object object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", "SYSTEM");
            this.composer.setProperty("T_TYPE", __TYPE__);
            this.composer.setProperty("T_CODE", __STATE__);
            this.composer.setProperty("POST_ID", this.POST_ID);
            this.composer.setProperty("M_ID", "noid");
            this.composer.setProperty("STEP", "0");
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "");
            this.composer.setProperty("DELAY", "");
            this.composer.setProperty("TOKEN_ID", "noemail");
            this.composer.setProperty("DOMAIN", "");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", __STATE_MSG__);
            this.composer.setProperty("LIST_TABLE", "n");
            SmtpLogger.put(this.composer);
        }
        this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS", __STATE__);
        eMsConnection emsConnection = null;
        eMsStatement stmt = null;
        List list = this.INSTANCE_QUERY_UPDATE_STATE_INFO;
        synchronized (list) {
            try {
                emsConnection = ConnectionPool.getConnection();
                stmt = emsConnection.createStatement();
                Iterator iter = this.INSTANCE_QUERY_UPDATE_STATE_INFO.iterator();
                while (iter.hasNext()) {
                    String query = iter.next().toString();
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, query, this.TASK_PROPERTY, "${", "}", true, false);
                    stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
                }
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
            }
            finally {
                emsConnection.recycleStatement(stmt);
                emsConnection.recycle();
            }
        }
    }

    @Override
    public void doErrorProcess(Throwable thr) {
        this.updateTaskState("41", "41", StringUtil.nl2blank(thr.toString()));
        super.doErrorProcess(thr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
        Object object;
        this.SPOOL_ANALYZER.parse(spool);
        if (this.SPOOL_ANALYZER.getIntStep() == 0) {
            object = this.composer.getLock();
            synchronized (object) {
                this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
                this.composer.setProperty("T_TYPE", "54");
                this.composer.setProperty("T_CODE", "00");
                this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
                this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
                this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
                this.composer.setProperty("T_DATE", Cal.getDate());
                this.composer.setProperty("MX_RECORD", "");
                this.composer.setProperty("DELAY", "");
                this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
                this.composer.setProperty("DOMAIN", "");
                this.composer.setProperty("WORKER", this.getName());
                this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
                this.composer.setProperty("ETC_LOG", "250 Strart");
                SmtpLogger.put(this.composer);
            }
        }
        object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
            this.composer.setProperty("T_TYPE", "55");
            this.composer.setProperty("T_CODE", "10");
            this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
            this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
            this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "SYNTAX_ERROR");
            this.composer.setProperty("DELAY", "0");
            this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
            this.composer.setProperty("DOMAIN", "SYNTAX_ERROR");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", "550 Syntax Error");
            this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
            SmtpLogger.put(this.composer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void passDomainNotFound(String spool, Throwable e) throws Exception {
        Object object;
        this.SPOOL_ANALYZER.parse(spool);
        if (this.SPOOL_ANALYZER.getIntStep() == 0) {
            object = this.composer.getLock();
            synchronized (object) {
                this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
                this.composer.setProperty("T_TYPE", "54");
                this.composer.setProperty("T_CODE", "00");
                this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
                this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
                this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
                this.composer.setProperty("T_DATE", Cal.getDate());
                this.composer.setProperty("MX_RECORD", "no mx recored");
                this.composer.setProperty("DELAY", "0");
                this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
                this.composer.setProperty("DOMAIN", "no domain");
                this.composer.setProperty("WORKER", this.getName());
                this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
                this.composer.setProperty("ETC_LOG", "250 Strart");
                SmtpLogger.put(this.composer);
            }
        }
        object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
            this.composer.setProperty("T_TYPE", "55");
            this.composer.setProperty("T_CODE", "20");
            this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
            this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
            this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "no mx record");
            this.composer.setProperty("DELAY", "0");
            this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
            this.composer.setProperty("DOMAIN", "no domain");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", "550 ".concat(e.toString()));
            this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
            SmtpLogger.put(this.composer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void passRejectDomain(String spool) throws Exception {
        Object object;
        this.SPOOL_ANALYZER.parse(spool);
        if (this.SPOOL_ANALYZER.getIntStep() == 0) {
            object = this.composer.getLock();
            synchronized (object) {
                this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
                this.composer.setProperty("T_TYPE", "54");
                this.composer.setProperty("T_CODE", "00");
                this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
                this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
                this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
                this.composer.setProperty("T_DATE", Cal.getDate());
                this.composer.setProperty("MX_RECORD", "NC");
                this.composer.setProperty("DELAY", "0");
                this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
                this.composer.setProperty("DOMAIN", this.SPOOL_ANALYZER.getDomain());
                this.composer.setProperty("WORKER", this.getName());
                this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
                this.composer.setProperty("ETC_LOG", "250 Strart");
                SmtpLogger.put(this.composer);
            }
        }
        object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
            this.composer.setProperty("T_TYPE", "55");
            this.composer.setProperty("T_CODE", "30");
            this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
            this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
            this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "NC");
            this.composer.setProperty("DELAY", "0");
            this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
            this.composer.setProperty("DOMAIN", this.SPOOL_ANALYZER.getDomain());
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", "550 TEMP REJECT DOMAIN");
            this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
            SmtpLogger.put(this.composer);
        }
    }
}

