/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.common.task.DenyFilterTask;
import pluto.common.task.HardBounceFilterTask;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.panopticon.filter.RejectFilter;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.schedule.Task;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.popper.Popper;

public abstract class AbstractMailSendTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(AbstractMailSendTask.class);
    public static int STOP_CHECK_RECYCLE = 1000;
    public static String ERR_CHECK = null;
    public static String DENY_CHECK = null;
    public static String ENC_PA = null;
    public static String ENC_YN = null;
    protected int instance_STOP_CHECK_RECYCLE = STOP_CHECK_RECYCLE;
    protected String WORK_FILE_ID = null;
    protected String POST_ID = null;
    protected String CHANNEL_TYPE = null;
    protected Throwable DOMAIN_NOT_FOUND_EXCEPTION = null;
    protected SpoolInfo mailSpoolInfo = null;
    protected ContentInfo SEND_CONTENT_INFO = null;
    protected SpoolAnalyzer SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
    protected Popper SPOOL_POPPER = null;
    protected String SPOOL_DIRECTORY = eMsSystem.getProperty("spool.temp.save.dir");
    protected static final String REALTIME_SEARCH = "05";
    protected static final String REALTIME_INPUT = "06";
    protected static String QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO;

    public AbstractMailSendTask() throws Exception {
        this(1, 60000L);
    }

    protected AbstractMailSendTask(short type) throws Exception {
        this(type, 60000L);
    }

    protected AbstractMailSendTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    protected boolean isPossibleProcessing() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        try {
            if (!this.isPossibleProcessing()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_Startup Method...");
            }
            this.execute_Startup();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_Startup Method...[OK]");
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ContentLoad Method...");
            }
            this.execute_ContentLoad();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ContentLoad Method...[OK]");
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListMake Method...");
            }
            this.execute_ListMake();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListMake Method...[OK]");
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListLoad Method...");
            }
            this.execute_ListLoad();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListLoad Method...[OK]");
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListSend Method...");
            }
            this.execute_ListSend();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_ListSend Method...[OK]");
            }
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_Finish Method...");
            }
            this.execute_Finish();
            if (log.isDebugEnabled()) {
                log.debug(" is execute execute_Finish Method...[OK]");
            }
        }
        catch (SendStopException e) {
            this.update_thread_status("32");
            log.error(this.getName(), (Throwable)e);
        }
    }

    protected void update_thread_status(String thread_code) throws Exception {
        this.TASK_PROPERTY.setProperty("THREAD_STATUS", thread_code);
        eMsConnection conn = null;
        eMsStatement stmt = null;
        try {
            conn = ConnectionPool.getConnection();
            stmt = conn.createStatement();
            StringBuffer buffer = new StringBuffer();
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO, this.TASK_PROPERTY, "${", "}", true, false);
            stmt.executeUpdate(buffer.toString());
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                conn.recycleStatement(stmt);
                conn.recycle();
            }
        }
    }

    protected synchronized void execute_ListSend() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend");
        }
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                log.debug("No Real Data.... So Skip");
                return;
            }
            try {
                this.SPOOL_POPPER.setTaskProp(this.TASK_PROPERTY);
                this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
            }
            catch (Exception ex) {
                log.error("spool popper error", (Throwable)ex);
            }
        } else {
            log.debug("MAIL SPOOL INFO IS NULL SO SKIP..");
            return;
        }
        if (this.SPOOL_POPPER == null) {
            log.error(this.getName(), (Object)"No Real Data.... So Skip");
            return;
        }
        if (this.execute_StopCheck()) {
            throw new SendStopException(this.getName() + " receive stop signal");
        }
        RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
        String nextSpool = null;
        String domain = null;
        int spoolPatchCount = 0;
        BufferedAgentPool pool = null;
        String email_str = null;
        String email_en = null;
        String ori_Spool = null;
        StringBuffer strBuffer = new StringBuffer(1024);
        int email_en_len = 0;
        while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
            if (nextSpool == null || nextSpool.length() < 1) continue;
            if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            try {
                if ("Y".equals(ENC_YN)) {
                    email_en = this.getSecureEmail(nextSpool);
                    email_str = this.getDecryptEmail(email_en);
                    domain = StringUtil.getDomain(email_str);
                    email_en_len = email_en.length();
                    strBuffer.setLength(0);
                    strBuffer.append(email_en).append("<TMS_DECRYPT>").append(email_str).append(nextSpool.substring(email_en_len));
                    ori_Spool = nextSpool;
                    nextSpool = strBuffer.toString();
                } else {
                    email_str = this.getSecureEmail(nextSpool);
                    domain = StringUtil.getDomain(email_str);
                }
                if (domain == null) {
                    this.processSyntaxErrorSpool(nextSpool);
                    continue;
                }
                if (MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain)) {
                    this.passRejectDomain(nextSpool);
                    continue;
                }
                if (ERR_CHECK.equals("Y") && !email_str.equals("") && HardBounceFilterTask.checkErrEmail(email_str)) {
                    this.passRejectDomain(nextSpool);
                    continue;
                }
                if (DENY_CHECK.equals("Y") && !email_str.equals("") && DenyFilterTask.checkDenyEmail(email_str)) {
                    this.passRejectDomain(nextSpool);
                    continue;
                }
                if (instanceRejectFilter != null) {
                    this.SPOOL_ANALYZER.parse(nextSpool);
                    if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                    nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                }
                this.DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
                if (this.DOMAIN_NOT_FOUND_EXCEPTION != null && this.DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException) {
                    this.passDomainNotFound(nextSpool, this.DOMAIN_NOT_FOUND_EXCEPTION);
                    continue;
                }
                pool = this.getBufferedObjectPool(domain);
                pool.registSpool(domain, nextSpool);
            }
            catch (OutOfMemoryError outError) {
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(ori_Spool);
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable err) {
                log.error("error", err);
                ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    public String getSecureEmail(String spool) {
        if (spool == null) {
            return null;
        }
        int idx1 = spool.indexOf("|");
        if (idx1 < 0) {
            return null;
        }
        return spool.substring(0, idx1);
    }

    public String getSecureSms(String spool) {
        if (spool == null) {
            return null;
        }
        int idx1 = spool.indexOf("|");
        if (idx1 < 0) {
            return null;
        }
        return spool.substring(0, idx1);
    }

    public String getDecryptEmail(String en_email) throws Exception {
        String email = "";
        try {
            email = en_email.indexOf("@") > 0 ? en_email : CryptoUtil.deEmailAddr(en_email);
        }
        catch (Exception e) {
            e.printStackTrace();
            return en_email;
        }
        if (StringUtil.isError(email)) {
            return null;
        }
        return email.trim();
    }

    public String getDecryptSms(String en_sms) throws Exception {
        String sms = "";
        try {
            sms = en_sms.length() < 15 ? en_sms : CryptoUtil.deEmailAddr(en_sms);
            return sms.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return en_sms;
        }
    }

    protected synchronized void execute_MassResend_ListSend() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend");
        }
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                log.debug("No Real Data.... So Skip");
                return;
            }
            try {
                this.SPOOL_POPPER.init(null, this.mailSpoolInfo.getSpoolFilesInfo());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.toString());
            }
        } else {
            log.debug("MAIL SPOOL INFO IS NULL SO SKIP..");
            return;
        }
        if (this.SPOOL_POPPER == null) {
            log.error("No Real Data.... So Skip");
            return;
        }
        if (this.execute_StopCheck()) {
            throw new SendStopException(this.getName() + " receive stop signal");
        }
        RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
        String nextSpool = null;
        String domain = null;
        int spoolPatchCount = 0;
        BufferedAgentPool pool = null;
        String email_str = null;
        String email_en = null;
        Object ori_Spool = null;
        StringBuffer strBuffer = new StringBuffer(1024);
        int email_en_len = 0;
        while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
            if (nextSpool == null || nextSpool.length() < 1) continue;
            if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            try {
                email_en = this.getSecureEmail(nextSpool);
                email_str = this.getDecryptEmail(email_en);
                domain = StringUtil.getDomain(email_str);
                email_en_len = email_en.length();
                strBuffer.setLength(0);
                strBuffer.append(email_en).append("<TMS_DECRYPT>").append(email_str).append(nextSpool.substring(email_en_len));
                nextSpool = strBuffer.toString();
                if (domain == null) {
                    this.processSyntaxErrorSpool(nextSpool);
                    continue;
                }
                if (MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain)) {
                    this.passRejectDomain(nextSpool);
                    continue;
                }
                if (instanceRejectFilter != null) {
                    this.SPOOL_ANALYZER.parse(nextSpool);
                    if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                    nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                }
                this.DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
                if (this.DOMAIN_NOT_FOUND_EXCEPTION != null && this.DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException) {
                    this.passDomainNotFound(nextSpool, this.DOMAIN_NOT_FOUND_EXCEPTION);
                    continue;
                }
                pool = this.getBufferedObjectPool(domain);
                pool.registSpool(domain, nextSpool);
            }
            catch (OutOfMemoryError outError) {
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(ori_Spool);
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable err) {
                log.error("error", err);
                ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    protected abstract void execute_ListMake() throws Exception;

    protected void execute_ListLoad() throws Exception {
        String spoolInfoConfig = this.TASK_PROPERTY.getProperty("SPOOL_CONF");
        this.mailSpoolInfo = SpoolInfo.XmlToSpoolInfo(spoolInfoConfig);
        SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
    }

    protected void execute_ContentLoad() throws Exception {
        String contentInfoConfig = this.TASK_PROPERTY.getProperty("CONTENT_CONF");
        String push_msg = this.TASK_PROPERTY.getProperty("PUSH_MSG", "");
        String push_title = this.TASK_PROPERTY.getProperty("PUSH_TITLE", "");
        this.SEND_CONTENT_INFO = ContentInfo.XmlToContentInfo(contentInfoConfig);
        if (!StringUtil.isNull(push_msg)) {
            this.SEND_CONTENT_INFO.getScheduleInfo().setProperty("PUSH_MSG", push_msg);
        }
        if (!StringUtil.isNull(push_title)) {
            this.SEND_CONTENT_INFO.getScheduleInfo().setProperty("PUSH_TITLE", push_title);
        }
        ContentInfoManager.putContentInfo(this.SEND_CONTENT_INFO, false);
    }

    protected abstract void execute_Startup() throws Exception;

    protected abstract void execute_Finish() throws Exception;

    protected abstract boolean execute_StopCheck();

    protected abstract BufferedAgentPool getBufferedObjectPool(String var1) throws Exception;

    protected abstract void passDomainNotFound(String var1, Throwable var2) throws Exception;

    protected abstract void passRejectDomain(String var1) throws Exception;

    protected abstract void processSyntaxErrorSpool(String var1) throws Exception;

    static {
        try {
            STOP_CHECK_RECYCLE = Integer.parseInt(eMsSystem.getProperty("stop.check.cycle", "1000"));
            ERR_CHECK = eMsSystem.getProperty("hardbounce.filter.check", "N");
            DENY_CHECK = eMsSystem.getProperty("deny.filter.check", "N");
            ENC_PA = eMsSystem.getProperty("member.info.encrypt.key", "amail0722!@");
            ENC_YN = eMsSystem.getProperty("member.info.encrypt.yn", "N");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
        QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO = null;
    }
}

