/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.communicator;

import java.util.Properties;
import jupiter.common.communicator.SmtpCommunicator;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.util.StringUtil;

public class SingleContentSmtpCommunicator
extends SmtpCommunicator {
    private static final Logger log = LoggerFactory.getLogger(SingleContentSmtpCommunicator.class);
    public static final String MAIL_BODY_CLASS_NAME = "mercury.contents.common.body.SingleTonMailBody";
    public static final String BODY_PARSER_CLASS_NAME = "mercury.contents.common.parser.StringBodyParser";
    public static final String MESSAGE_CLASS_NAME = "mercury.contents.common.message.SimpleMessage";
    public static final int CONSTANT_CONNECTION_TIME_OUT = 30000;
    protected long timeInterval = 0L;
    protected String returnPath = null;
    protected String tokenData = null;
    protected String toToken = null;
    protected MailBody mailBody = null;
    protected BodyParser bodyParser = null;
    protected Message message = null;

    public SingleContentSmtpCommunicator() throws Exception {
        this("StandAloneSmtpCommunicator");
    }

    public SingleContentSmtpCommunicator(String name) throws Exception {
        super(true);
        this.setName(name);
        this.mailBody = (MailBody)Class.forName(MAIL_BODY_CLASS_NAME).newInstance();
        this.bodyParser = (BodyParser)Class.forName(BODY_PARSER_CLASS_NAME).newInstance();
        this.message = (Message)Class.forName(MESSAGE_CLASS_NAME).newInstance();
        this.message.setContentType(new Short(2));
        this.message.setCharSet(eMsLocale.MAIL_MIME_CHAR_SET);
        this.message.setContentEncoding(new Short(eMsLocale.MAIL_ENC_TYPE));
        this.message.setMessageID("SingleContentSmtpCommunicator's message");
        this.message.setContent(this.bodyParser);
        this.mailBody.setMessage(this.message);
        this.mailBody.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        this.INSTANCE_TIMEOUT_INIT = 30000;
    }

    public void setProperty(Properties prop) throws Exception {
        this.returnPath = prop.getProperty("RETURN_PATH");
        this.toToken = prop.getProperty("TMS_M_TOKEN");
        this.domain = StringUtil.getDomain(this.toToken);
        this.mailBody.setSubject(prop.getProperty("SUBJECT"));
        this.mailBody.setFromName(prop.getProperty("FROM_NAME"));
        this.mailBody.setFromEmail(prop.getProperty("FROM_EMAIL"));
        this.mailBody.setToName(prop.getProperty("TMS_M_NAME"));
        this.mailBody.setToEmail(prop.getProperty("TMS_M_TOKEN"));
        this.bodyParser.setContents(prop.getProperty("CONTENT"));
        this.tokenData = this.mailBody.getMailBody(prop, null, null);
    }

    public String execute() {
        String resultString = null;
        this.timeInterval = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("into connect");
        }
        try {
            resultString = this.innerWork();
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            resultString = "FATAL ERROR:".concat(e.toString());
        }
        if (this.CURR_STEP > 3) {
            if (log.isDebugEnabled()) {
                log.debug("step QUIT");
            }
            this.step((short)8, null, this.domain, 0);
        }
        if (log.isDebugEnabled()) {
            log.debug("step CLOSE");
        }
        this.close();
        return resultString;
    }

    private String innerWork() throws Exception {
        this.CURR_STEP = 0;
        if (log.isDebugEnabled()) {
            log.debug("step connect DOMAIN");
        }
        this.connect(this.domain, "0");
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        this.step((short)3, eMsLocale.SMTP_LOCAL_HOST[0], this.domain, 0);
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        this.step((short)4, this.returnPath, this.domain, 0);
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        this.CURR_STEP = (short)4;
        this.step((short)5, this.toToken, this.domain, 0);
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        this.CURR_STEP = (short)5;
        this.step((short)6, null, this.domain, 0);
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        this.CURR_STEP = (short)6;
        this.step((short)7, this.tokenData, this.domain, 0);
        if (this.sendState.isError()) {
            return this.sendState.getMESSAGE();
        }
        return this.sendState.getMESSAGE();
    }

    @Override
    public void log(String log) {
    }
}

