/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import com.humuson.tms.constrants.StatusType;
import java.util.Properties;
import jupiter.auto.send.task.CampListMakeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;

public class FatigueFilterCampListMakeTask
extends CampListMakeTask {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilterCampListMakeTask.class);
    protected static String QUERY_SELECT_FILTER_USEYN = null;
    protected static String QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = null;
    protected static String QUERY_SEND_CNT_UPDATE = null;
    private static String ORACLE = "ORACLE";
    private static String ORACLE_REPLACE_HINT = "##ORACLE_REPLACE_HINT##";

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
    }

    @Override
    protected boolean isPossibleProcessing() {
        this.updateTaskState("41", "10");
        return super.isPossibleProcessing();
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    protected Properties isUseFatigueFilter(Properties TARGET_PROPERTIES) throws Exception {
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsConnection emsConnection = null;
        eMsResultSet rs = null;
        Object ex = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            __SELECT_STATEMENT__ = emsConnection.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_FILTER_USEYN, TARGET_PROPERTIES, "${", "}", true, false);
            rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
            if (rs.next()) {
                TARGET_PROPERTIES.setProperty("FATIGUE_DAY_LIMIT", rs.getString("FATIGUE_DAY_LIMIT"));
                TARGET_PROPERTIES.setProperty("FATIGUE_MONTH_LIMIT", rs.getString("FATIGUE_MONTH_LIMIT"));
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            emsConnection.recycleStatement(__SELECT_STATEMENT__);
            emsConnection.recycle();
        }
        return TARGET_PROPERTIES;
    }

    protected int insertFatigueListSentCnt(Properties TARGET_PROPERTIES, String dateType) throws Exception {
        int successCnt = 0;
        eMsStatement __UPDATE_STATEMENT__ = null;
        eMsConnection emsConnection = null;
        Object ex = null;
        String fatigueDate = "";
        boolean isFail = false;
        try {
            emsConnection = ConnectionPool.getConnection();
            __UPDATE_STATEMENT__ = emsConnection.createStatement();
            TARGET_PROPERTIES.setProperty("FATIGUE_TABLE", this.getFatigueListTableName(this.CHANNEL_TYPE, dateType));
            fatigueDate = "";
            if (dateType.equals("DAY")) {
                fatigueDate = TARGET_PROPERTIES.getProperty("POST_ID").substring(0, 8);
                log.info("WORKDAY : {} DATETYPE : {}", (Object)fatigueDate, (Object)dateType);
            } else if (dateType.equals("MONTH")) {
                fatigueDate = TARGET_PROPERTIES.getProperty("POST_ID").substring(0, 6);
                log.info("WORKDAY : {} DATETYPE : {}", (Object)fatigueDate, (Object)dateType);
            }
            TARGET_PROPERTIES.setProperty("FATIGUE_DATE", fatigueDate);
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SEND_CNT_UPDATE, TARGET_PROPERTIES, "${", "}", true, false);
            String query = this.TMP_STRING_BUFFER.toString();
            if (ORACLE.equalsIgnoreCase(eMsLocale.DB_TYPE)) {
                String pkHint = TARGET_PROPERTIES.getProperty("LIST_TABLE").replace("TMS", "PK");
                query = query.replace(ORACLE_REPLACE_HINT, pkHint);
            }
            successCnt = __UPDATE_STATEMENT__.executeUpdate(query);
        }
        catch (Exception e) {
            isFail = true;
            log.error(e.toString());
            throw e;
        }
        finally {
            if (isFail) {
                this.updateTaskState("41", StatusType.ERROR.getCode());
            }
            emsConnection.recycleStatement(__UPDATE_STATEMENT__);
            emsConnection.recycle();
        }
        return successCnt;
    }

    protected String getFatigueListTableName(String ChannelType2, String dateType) {
        String targetFatigueListTable = "";
        switch (ChannelType2) {
            case "EM": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_EMAIL_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_EMAIL_MONTH_LIST";
                break;
            }
            case "SM": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_SMS_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_SMS_MONTH_LIST";
                break;
            }
            case "KA": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_KAKAO_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_KAKAO_MONTH_LIST";
                break;
            }
            case "PU": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_PUSH_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_PUSH_MONTH_LIST";
                break;
            }
            default: {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_MONTH_LIST";
            }
        }
        return targetFatigueListTable;
    }

    public static void main(String[] args) {
        System.out.println("2017032800001".substring(0, 6));
    }

    static {
        try {
            QUERY_SELECT_FILTER_USEYN = SqlManager.getQuery("FILTER_INFO", "QUERY_SELECT_FILTER_USEYN");
            QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = SqlManager.getQuery("FILTER_INFO", "QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE");
            QUERY_SEND_CNT_UPDATE = SqlManager.getQuery("FILTER_INFO", "QUERY_SEND_CNT_UPDATE");
        }
        catch (Exception ignore) {
            log.error(ignore.getMessage());
        }
    }
}

