/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.ArrayList;
import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.reporter.Reporter;
import pluto.util.Cal;

public class AdditionalSendTask
extends CommonStepMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(AdditionalSendTask.class);
    protected static String QUERY_SELECT_RESEND_TABLE_INFO = null;
    protected static String QUERY_SELECT_LIST_LOAD_QUERY = null;
    protected static String QUERY_UPDATE_LIST_STATE_QUERY = null;
    protected String MAIL_ID = "";
    protected ArrayList TARGET_TABLE_LIST = null;

    public AdditionalSendTask() throws Exception {
        this.setName("AdditionalSendTask");
        this.setTaskID("AdditionalSendTask");
        this.TARGET_TABLE_LIST = new ArrayList();
        this.SPOOL_ANALYZER.setSendType("AUTORESEND");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("N");
        this.SPOOL_ANALYZER.setLimitDate("19000000");
        this.SPOOL_ANALYZER.setStep(0);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public void setTaskProperty(Properties send_info) {
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.WORK_FILE_ID = "RESEND_".concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setStep(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Startup() throws Exception {
        block13: {
            eMsStatement __EMS_EXEC_STATEMENT__ = null;
            eMsResultSet rsSelectedScheduleInfo = null;
            this.TARGET_TABLE_LIST.clear();
            eMsConnection emsConnection = null;
            Exception ex = null;
            try {
                emsConnection = ConnectionPool.getConnection();
                __EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
                rsSelectedScheduleInfo = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_RESEND_TABLE_INFO);
                while (rsSelectedScheduleInfo.next()) {
                    Properties prop = new Properties();
                    rsSelectedScheduleInfo.putToMap(prop, false);
                    this.MAIL_ID = prop.getProperty("MAIL_ID", "NO ID");
                    this.TARGET_TABLE_LIST.add(prop);
                }
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
                Reporter.report("[" + this.MAIL_ID + "]", this.getName(), "mailsendtask.init.err", e);
                ex = e;
            }
            finally {
                try {
                    if (rsSelectedScheduleInfo != null) {
                        rsSelectedScheduleInfo.close();
                    }
                }
                catch (Exception exception) {}
                emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
                emsConnection.recycle();
                if (ex == null) break block13;
                throw ex;
            }
        }
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
    }

    @Override
    protected void execute_ListMake() throws Exception {
    }

    @Override
    protected void execute_ListLoad() throws Exception {
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
    }

    @Override
    protected boolean execute_StopCheck() {
        return false;
    }

    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
    }

    @Override
    public void doErrorProcess(Throwable thr) {
        log.error(this.getName(), thr);
        Reporter.report("[" + this.MAIL_ID + "] " + this.POST_ID, this.getName(), "mailsendtask.exec.err", thr);
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    @Override
    protected void execute_Finish() throws Exception {
    }

    static {
        try {
            QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_SELECT_RESEND_TABLE_INFO");
            QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_SELECT_LIST_LOAD_QUERY");
            QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_UPDATE_LIST_STATE_QUERY");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

