/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.actor;

import freemarker20.ext.beans.StaticModels;
import freemarker20.template.SimpleHash;
import freemarker20.template.TemplateModel;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.FileElement;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.log.Log;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.handler.LongMappingSpoolReader;
import venus.spool.common.parser.SpoolHashParser;

public class ContentsPreviewInfoActor
extends Name
implements InfoActor,
Log {
    private static final Logger log = LoggerFactory.getLogger(ContentsPreviewInfoActor.class);
    protected static SpoolHashParser AUTO_KEY_VALUE_PARSER = null;
    protected static ByteArrayOutputStream INNER_BYTE_ARRAY = null;
    protected static SimpleHash _MEMBER_HASH_ = null;
    protected static ContentPD INNER_CONTENT_MAKE_INSTANCE = null;

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        INNER_CONTENT_MAKE_INSTANCE = (ContentPD)Class.forName(prop.getProperty("instant.content.make.class")).newInstance();
    }

    public ContentsPreviewInfoActor() {
        this.setName("PreviewInfoActor_" + Cal.getSerialDate());
    }

    @Override
    public void execute(InfoBeans arg) throws Exception {
        ContentsPreviewInfoActor.inner_execute(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void inner_execute(InfoBeans arg) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        Properties prop = arg.getArgs();
        String MEMBER_ID = prop.getProperty("MEMBER_ID");
        String TO_TOKEN = prop.getProperty("TO_EMAIL");
        String POST_ID = prop.getProperty("POST_ID");
        String MEMBER_MAPPING = prop.getProperty("MAPPING");
        if (StringUtil.isNull(POST_ID)) {
            POST_ID = prop.getProperty("WORKDAY") + "_" + prop.getProperty("SEQNO");
            log.debug("[POST_ID IS NULL]==> REMAKE:" + POST_ID);
        }
        if (log.isDebugEnabled()) {
            log.debug(prop.toString());
        }
        ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(POST_ID);
        SpoolInfo sendSpoolInfo = SpoolInfoManager.getSpoolInfo(POST_ID);
        if (sendContentInfo == null) {
            if (INNER_CONTENT_MAKE_INSTANCE == null) {
                prop.setProperty("CONTENTS", "CONTENT INFO DOSE NOT EXIST!!!");
                return;
            }
            try {
                INNER_CONTENT_MAKE_INSTANCE.process(prop);
                sendContentInfo = INNER_CONTENT_MAKE_INSTANCE.getContentInfo();
                ContentInfoManager.registContentInfo(sendContentInfo);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error(e.getMessage());
                }
                prop.setProperty("CONTENTS", "INSTANT CONTENT MAKE ERROR:" + e.toString());
                return;
            }
        }
        if (MEMBER_MAPPING.startsWith("isam://")) {
            byteArrayOutputStream = INNER_BYTE_ARRAY;
            synchronized (byteArrayOutputStream) {
                INNER_BYTE_ARRAY.reset();
                int idx_of_comma = MEMBER_MAPPING.indexOf(",", 7);
                int idx_of_at = MEMBER_MAPPING.indexOf("@", idx_of_comma);
                long start = Long.parseLong(MEMBER_MAPPING.substring(7, idx_of_comma));
                long end = Long.parseLong(MEMBER_MAPPING.substring(idx_of_comma + 1, idx_of_at));
                LongMappingSpoolReader reader = LongMappingSpoolReader.getInstance(MEMBER_MAPPING.substring(idx_of_at + 1).replace('\\', '/'));
                reader.inner_get(start, end, INNER_BYTE_ARRAY);
                MEMBER_MAPPING = INNER_BYTE_ARRAY.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
            }
        }
        if (MEMBER_MAPPING.startsWith("file://")) {
            byteArrayOutputStream = INNER_BYTE_ARRAY;
            synchronized (byteArrayOutputStream) {
                INNER_BYTE_ARRAY.reset();
                FileElement.putFileBodyToStream(MEMBER_MAPPING.substring(7), INNER_BYTE_ARRAY);
                MEMBER_MAPPING = INNER_BYTE_ARRAY.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
            }
        }
        byteArrayOutputStream = _MEMBER_HASH_;
        synchronized (byteArrayOutputStream) {
            _MEMBER_HASH_.clear();
            if (log.isDebugEnabled()) {
                log.debug("MAP: " + MEMBER_MAPPING);
            }
            if (log.isDebugEnabled()) {
                log.debug("KEYMAP: " + sendSpoolInfo.getHEADER_KEY_MAP("|").toString());
            }
            if (MEMBER_MAPPING.startsWith("#P#:")) {
                StringConvertUtil.ConvertStringToSimpleHash(_MEMBER_HASH_, MEMBER_MAPPING);
            } else {
                AUTO_KEY_VALUE_PARSER.setDelim(sendContentInfo.getScheduleInfo().getProperty("DELIMIT", "|"));
                AUTO_KEY_VALUE_PARSER.parse(_MEMBER_HASH_, MEMBER_MAPPING, sendSpoolInfo.getHEADER_KEY_MAP("|"), sendSpoolInfo.getDefaultSimpleHashMapping());
            }
            if (_MEMBER_HASH_.containsKey((Object)"SERIAL_MAPPING")) {
                AUTO_KEY_VALUE_PARSER.parseSerialMapping(_MEMBER_HASH_, _MEMBER_HASH_.getAsString("SERIAL_MAPPING"), sendContentInfo.getScheduleInfo().getProperty("DELIMIT", "|"));
            }
            _MEMBER_HASH_.put("m_id", MEMBER_ID);
            _MEMBER_HASH_.put("m_email", TO_TOKEN);
            _MEMBER_HASH_.put("m_name", prop.getProperty("MEMBER_NAME"));
            _MEMBER_HASH_.put("p_id", POST_ID);
            _MEMBER_HASH_.put("TMS_M_ID", MEMBER_ID);
            _MEMBER_HASH_.put("EMS_M_TOKEN", TO_TOKEN);
            _MEMBER_HASH_.put("TMS_M_NAME", prop.getProperty("MEMBER_NAME"));
            _MEMBER_HASH_.put("enc_mid", TrackingInfoConvertor.enc_MEMBER_ID("preView_1"));
            _MEMBER_HASH_.put("enc_p_id", TrackingInfoConvertor.enc_MAIL_ID(POST_ID));
            _MEMBER_HASH_.put("enc_t_close", TrackingInfoConvertor.enc_CLOSE("19000101"));
            _MEMBER_HASH_.put("statics", (TemplateModel)StaticModels.INSTANCE);
            prop.setProperty("CONTENTS", sendContentInfo.getPreViewMailBody(_MEMBER_HASH_, sendSpoolInfo.getDefaultMapping()));
        }
    }

    static {
        AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");
        INNER_BYTE_ARRAY = new ByteArrayOutputStream(1024);
        _MEMBER_HASH_ = new SimpleHash();
    }
}

