/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.task;

import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import venus.spool.auto.task.SmsCampBaseSpoolTask;

public class RecvFilterSmsSpoolTask
extends SmsCampBaseSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(RecvFilterSmsSpoolTask.class);
    protected static String QUERY_SELECT_FILTER_USEYN = null;
    protected static String QUERY_UPDATE_FATIGUE_LIST_QUERY = null;
    protected static String QUERY_INSERT_FATIGUE_LIST_QUERY = null;
    protected static String QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT = null;
    protected static String QUERY_UPDATE_FATIGUE_CNT_QUERY = null;
    protected static String QUERY_UPDATE_SCHEDULE_FATIGUE_CNT = null;
    protected static boolean FATIGUE_USE_YN;

    @Override
    protected void execute_ListLoad(Properties targetProperties) throws Exception {
        this.checkFilterUse(targetProperties);
        if (FATIGUE_USE_YN) {
            this.filterFatigueList(targetProperties);
        }
        super.execute_ListLoad(targetProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFilterUse(Properties targetProperties) throws Exception {
        block13: {
            eMsStatement __SELECT_STATEMENT__ = null;
            eMsResultSet rs = null;
            Exception ex = null;
            try {
                __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_FILTER_USEYN, targetProperties, "${", "}", true, false);
                rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                if (rs.next()) {
                    FATIGUE_USE_YN = rs.getString("FATIGUE_USE_YN").equals("Y");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                ex = e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
                this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
                if (ex == null) break block13;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void filterFatigueList(Properties targetProperties) throws Exception {
        block24: {
            eMsStatement __SELECT_STATEMENT__ = null;
            eMsResultSet rs = null;
            Exception ex = null;
            try {
                __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT, targetProperties, "${", "}", true, false);
                rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                if (rs.next()) {
                    targetProperties.setProperty("HOUR_LIMIT", rs.getString("HOUR_LIMIT"));
                    targetProperties.setProperty("DAY_LIMIT", rs.getString("DAY_LIMIT"));
                    targetProperties.setProperty("WEEK_LIMIT", rs.getString("WEEK_LIMIT"));
                    targetProperties.setProperty("MON_LIMIT", rs.getString("MON_LIMIT"));
                }
            }
            catch (Exception e) {
                log.error(e.toString());
                ex = e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
                this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
                if (ex == null) break block24;
                throw ex;
            }
        }
        long sTime = System.currentTimeMillis();
        int fatigueCnt = this.updateFilterList(QUERY_UPDATE_FATIGUE_LIST_QUERY, targetProperties);
        log.error("list update time:[" + (System.currentTimeMillis() - sTime) + "] CNT :[" + fatigueCnt + "]");
        if (fatigueCnt < 1) {
            log.error("fatigue list update fail");
        } else {
            targetProperties.setProperty("FATIGUE_CNT", String.valueOf(fatigueCnt));
            sTime = System.currentTimeMillis();
            if (this.updateFilterList(QUERY_UPDATE_SCHEDULE_FATIGUE_CNT, targetProperties) < 1) {
                log.error("fatigue cnt update fail");
            }
            log.error("schedule update time:[" + (System.currentTimeMillis() - sTime) + "]");
        }
        sTime = System.currentTimeMillis();
        try {
            if (this.updateFilterList(QUERY_INSERT_FATIGUE_LIST_QUERY, targetProperties) >= 1) {
                // empty if block
            }
        }
        catch (Exception e) {
            log.error("fatigue list insert fail");
        }
        log.error("fatigue insert time:[" + (System.currentTimeMillis() - sTime) + "]");
        sTime = System.currentTimeMillis();
        int fatigueCnt2 = 0;
        try {
            fatigueCnt2 = this.updateFilterList(QUERY_UPDATE_FATIGUE_CNT_QUERY, targetProperties);
            if (fatigueCnt2 < 1) {
                log.error("fatigue cnt update fail");
            }
        }
        catch (SQLException se) {
            log.error("SQLException list insert START");
            fatigueCnt2 = this.updateFilterList(QUERY_UPDATE_FATIGUE_CNT_QUERY, targetProperties);
            if (fatigueCnt < 1) {
                log.error("fatigue cnt update fail");
            }
            log.error("SQLException list insert END");
        }
        catch (Exception e) {
            log.error("fatigue cnt update fail");
        }
        log.error("fatigue update time:[" + (System.currentTimeMillis() - sTime) + "] CNT :[" + fatigueCnt2 + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateFilterList(String query, Properties targetProperties) throws Exception {
        int successCnt;
        block5: {
            successCnt = 0;
            eMsStatement __UPDATE_STATEMENT__ = null;
            Exception ex = null;
            try {
                __UPDATE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, query, targetProperties, "${", "}", true, false);
                this.EMS_CONNECTION.setAutoCommit(false);
                successCnt = __UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString());
                this.EMS_CONNECTION.commit();
                this.EMS_CONNECTION.setAutoCommit(true);
            }
            catch (Exception e) {
                this.EMS_CONNECTION.rollback();
                log.error(e.getMessage());
                ex = e;
                return (int)ex;
            }
            finally {
                this.EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
                if (ex == null) break block5;
                throw ex;
            }
        }
        return successCnt;
    }

    static {
        try {
            QUERY_SELECT_FILTER_USEYN = SqlManager.getQuery("FILTER_INFO", "QUERY_SELECT_FILTER_USEYN");
            QUERY_UPDATE_FATIGUE_LIST_QUERY = SqlManager.getQuery("FILTER_INFO", "QUERY_UPDATE_FATIGUE_LIST_QUERY");
            QUERY_INSERT_FATIGUE_LIST_QUERY = SqlManager.getQuery("FILTER_INFO", "QUERY_INSERT_FATIGUE_LIST_QUERY");
            QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT = SqlManager.getQuery("FILTER_INFO", "QUERY_SELECT_FATIGUE_PERIOD_LIMIT_CNT");
            QUERY_UPDATE_FATIGUE_CNT_QUERY = SqlManager.getQuery("FILTER_INFO", "QUERY_UPDATE_FATIGUE_CNT_QUERY");
            QUERY_UPDATE_SCHEDULE_FATIGUE_CNT = SqlManager.getQuery("FILTER_INFO", "QUERY_UPDATE_SCHEDULE_FATIGUE_CNT");
        }
        catch (Exception ignore) {
            log.error(ignore.getMessage());
        }
        FATIGUE_USE_YN = false;
    }
}

