/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.basic;

import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.DefaultMappingGenerator;

public class MassBasicDefaultMappingGenerator
extends Name
implements DefaultMappingGenerator {
    private static final Logger log = LoggerFactory.getLogger(MassBasicDefaultMappingGenerator.class);
    protected static String QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected Properties SCHEDULE_INFO = null;
    protected Map DEFAULT_MAPPPING_MAP = new Hashtable();
    protected ByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = new ByteArrayOutputStream(1024);
    protected StringBuffer TMP_STRING_BUFFER = null;

    protected void inner_init(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
        this.setName(this.SCHEDULE_INFO.getProperty("POST_ID") + "_MassBasicDefaultMappingGenerator");
    }

    @Override
    public void process(Properties prop) throws Exception {
        this.inner_init(prop);
        String area_id = this.SCHEDULE_INFO.getProperty("AREA_ID", "-");
        if (area_id.equals("-") || StringUtil.isNull(area_id)) {
            return;
        }
        try {
            log.debug(this.getName() + " Request Connection");
            this.EMS_CONNECTION = ConnectionPool.getConnection();
            log.debug(" Get Connetion " + this.EMS_CONNECTION.getName());
        }
        catch (Exception e) {
            if (this.EMS_CONNECTION != null) {
                this.EMS_CONNECTION.destroy();
            }
            log.debug(this.getName() + " Request Connection Error");
            throw e;
        }
        try {
            this.TMP_STRING_BUFFER = new StringBuffer(256);
            if (log.isDebugEnabled()) {
                log.debug("exec_setKeyValueDefaultMapping START");
            }
            this.exec_setKeyValueDefaultMapping();
            if (log.isDebugEnabled()) {
                log.debug("exec_setKeyValueDefaultMapping END");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.TMP_STRING_BUFFER = null;
            this.EMS_CONNECTION.recycle();
            if (log.isDebugEnabled()) {
                log.debug("default_mapping", (Object)this.DEFAULT_MAPPPING_MAP.toString());
            }
        }
    }

    @Override
    public Map getMapOfDefaultMapping() {
        return this.DEFAULT_MAPPPING_MAP;
    }

    @Override
    public Map getMapOfDefaultHashMapping() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec_setKeyValueDefaultMapping() throws Exception {
        eMsResultSet rs = null;
        eMsStatement stmt = null;
        String __KEY_STRING__ = null;
        String __VALUE_STRING__ = null;
        String __EXEC_TARGET_QUERY__ = null;
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL, this.SCHEDULE_INFO, "${", "}", true, false);
            __EXEC_TARGET_QUERY__ = this.TMP_STRING_BUFFER.toString();
            if (log.isDebugEnabled()) {
                log.debug("=======================query===========================\n" + __EXEC_TARGET_QUERY__);
                log.debug(this.getName() + ".setKeyValueDefaultMapping() exe query:" + __EXEC_TARGET_QUERY__);
            }
            rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
            if (log.isDebugEnabled()) {
                log.debug(this.getName() + ".setKeyValueDefaultMapping() exe query:[OK]");
            }
            while (rs.next()) {
                __KEY_STRING__ = rs.getString(1);
                __VALUE_STRING__ = rs.getString(2);
                if (log.isDebugEnabled()) {
                    log.debug("[KEY]" + __KEY_STRING__ + "[VALUE]" + __VALUE_STRING__);
                }
                if (__VALUE_STRING__.startsWith("URL:")) {
                    ByteArrayOutputStream byteArrayOutputStream = this.INNER_BYTE_ARRAY_STREAM;
                    synchronized (byteArrayOutputStream) {
                        this.INNER_BYTE_ARRAY_STREAM.reset();
                        FileElement.putFileBodyToStream(__VALUE_STRING__.substring(4), this.INNER_BYTE_ARRAY_STREAM);
                        this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, this.INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
                        continue;
                    }
                }
                this.DEFAULT_MAPPPING_MAP.put(__KEY_STRING__, __VALUE_STRING__);
            }
        }
        catch (Exception e) {
            log.error(__EXEC_TARGET_QUERY__, (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ignore) {}
            this.EMS_CONNECTION.recycleStatement(stmt);
        }
        if (log.isDebugEnabled()) {
            log.debug("setKeyValueDefaultMapping END");
        }
    }

    static {
        QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL = SqlManager.getQuery("DEFAULT_MAPPING", "QUERY_SELECT_MASS_KEY_VELUE_MAPPING_SQL");
    }
}

