/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.auto.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;

public class CampTestSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(CampTestSpoolTask.class);
    public static List QUERY_UPDATE_STATE_START = null;
    public static List QUERY_UPDATE_STATE_END = null;
    public static List QUERY_UPDATE_STATE_INFO = null;
    public static String QUERY_SELECT_BASE_SEND_LIST = null;
    public static String QUERY_CHECK_STOP_FLAG = null;
    protected static String QUERY_UPDATE_SPOOL_CONF = null;
    protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
    protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;
    private static String QUERY_SELECT_TEST_EMAIL_LIST = null;
    protected List TEST_EMAIL_LIST = new LinkedList();
    private static String QUERY_SELECT_TEST_CNT_MYSQL = null;
    private static String QUERY_SELECT_TEST_CNT_MSSQL = null;
    private static String QUERY_SELECT_TEST_CNT_ORACLE = null;

    @Override
    public void setTaskProperty(Properties prop) {
        if (this.TASK_PROPERTY == null) {
            this.TASK_PROPERTY = new Properties();
        }
        if (prop != null) {
            this.TASK_PROPERTY.putAll((Map<?, ?>)prop);
        }
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_test_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_CampTestSpoolTask");
        ConnectInfo conInfo = null;
        try {
            conInfo = eMsConnection.getConnectInfo("ems");
        }
        catch (Exception e1) {
            log.error("connection error", (Throwable)e1);
        }
        String __EXEC_TARGET_QUERY__ = null;
        __EXEC_TARGET_QUERY__ = conInfo.getDB_URL().indexOf("oracle") > 0 ? CampTestSpoolTask.setQuerySample_oracle(QUERY_SELECT_BASE_SEND_LIST) : (conInfo.getDB_URL().indexOf("mysql") > 0 ? CampTestSpoolTask.setQuerySample_mysql(QUERY_SELECT_BASE_SEND_LIST) : CampTestSpoolTask.setQuerySample_mssql(QUERY_SELECT_BASE_SEND_LIST));
        this.SELECT_TARGET_LIST_QUERY = __EXEC_TARGET_QUERY__;
        this.UPDATE_TARGET_LIST_QUERY = null;
        this.APPEND_TOTAL_SPOOL = true;
        this.SPOOL_ANALYZER.setSendType("TEST");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("Y");
        this.SPOOL_ANALYZER.setLimitDate(this.TASK_PROPERTY.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(1)));
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setStep(0);
        try {
            this.getTestTargetList();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    protected static String setQuerySample_mysql(String query) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(query);
        buffer.append(" ");
        buffer.append(QUERY_SELECT_TEST_CNT_MYSQL);
        return buffer.toString();
    }

    protected static String setQuerySample_mssql(String query) {
        String select_str = "SELECT";
        String distinct_str = "DISTINCT";
        String uQuery = query.toUpperCase();
        int point_select = uQuery.indexOf(select_str);
        int point_distinct = uQuery.indexOf(distinct_str);
        int point = 0;
        point = point_distinct >= 0 ? point_distinct + distinct_str.length() : point_select + select_str.length();
        StringBuffer buffer = new StringBuffer();
        buffer.append(query.substring(0, point));
        buffer.append(" ");
        buffer.append(QUERY_SELECT_TEST_CNT_MSSQL.trim());
        buffer.append(" ");
        buffer.append(query.substring(point));
        return buffer.toString();
    }

    protected static String setQuerySample_oracle(String query) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(query);
        buffer.append(" and ");
        buffer.append(QUERY_SELECT_TEST_CNT_ORACLE);
        return buffer.toString();
    }

    protected synchronized void getTestTargetList() throws Exception {
        StringBuffer buffer = new StringBuffer(512);
        eMsConnection EMS_CONNECTION = null;
        eMsStatement SELECT_STATEMENT = null;
        eMsResultSet rs = null;
        String test_email = "";
        try {
            EMS_CONNECTION = ConnectionPool.getConnection();
            SELECT_STATEMENT = EMS_CONNECTION.createStatement();
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_TEST_EMAIL_LIST, this.TASK_PROPERTY, "${", "}", true, false);
            log.info("email test list :" + buffer.toString());
            rs = SELECT_STATEMENT.executeQuery(buffer.toString());
            while (rs.next()) {
                test_email = rs.getString("TEST_EMAIL");
                if (test_email.indexOf("::") > -1) {
                    String[] emailList = test_email.split("::");
                    int size = emailList.length;
                    for (int i = 0; i < size; ++i) {
                        this.TEST_EMAIL_LIST.add(emailList[i]);
                    }
                    continue;
                }
                this.TEST_EMAIL_LIST.add(test_email);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            EMS_CONNECTION.recycleStatement(SELECT_STATEMENT);
            SELECT_STATEMENT = null;
            EMS_CONNECTION.recycle();
        }
        if (this.TEST_EMAIL_LIST.size() < 1) {
            throw new NoTargetListException("NO TARGET LIST => " + this.TASK_PROPERTY.getProperty("SEND_LIST"));
        }
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
        String m_email = "";
        Iterator iter = this.TEST_EMAIL_LIST.iterator();
        while (iter.hasNext()) {
            m_email = iter.next().toString();
            this.SPOOL_ANALYZER.setTokenID(m_email);
            this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
            this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
            this.SPOOL_ANALYZER.setMapping(prop.getProperty("TOTAL_SPOOL_LINE"));
            this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
        }
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.TASK_PROPERTY.getProperty("POST_ID"));
        this.mailSpoolInfo.setSendState(this.TASK_PROPERTY.getProperty("SEND_STATE"));
        this.mailSpoolInfo.setMappingHeader(this.getMappingHeader());
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        SpoolInfoManager.registSpoolInfo(this.mailSpoolInfo);
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    @Override
    protected void execute_Finish(boolean success) throws Exception {
        log.debug("[CampTestSpoolTask]...Finish");
    }

    static {
        try {
            QUERY_SELECT_TEST_EMAIL_LIST = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_EMAIL_LIST");
            QUERY_SELECT_BASE_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_SELECT_BASE_SEND_LIST_TEST");
            QUERY_SELECT_TEST_CNT_MYSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MYSQL");
            QUERY_SELECT_TEST_CNT_MSSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MSSQL");
            QUERY_SELECT_TEST_CNT_ORACLE = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_ORACLE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

