/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.auto.task;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.auto.basic.BasicDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;

public class AutoBaseSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(AutoBaseSpoolTask.class);
    public static List QUERY_UPDATE_STATE_START = null;
    public static List QUERY_UPDATE_STATE_END = null;
    public static List QUERY_UPDATE_STATE_INFO = null;
    public static String QUERY_SELECT_BASE_SEND_LIST = null;
    public static String QUERY_SELECT_BASE_DIVIDE_SEND_LIST = null;
    public static String QUERY_CHECK_STOP_FLAG = null;
    protected static String QUERY_UPDATE_SPOOL_CONF = null;
    protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
    protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;

    @Override
    public void setTaskProperty(Properties prop) {
        if (this.TASK_PROPERTY == null) {
            this.TASK_PROPERTY = new Properties();
        }
        if (prop != null) {
            this.TASK_PROPERTY.putAll((Map<?, ?>)prop);
        }
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.rowid = this.TASK_PROPERTY.getProperty("ROW_ID");
        this.os = this.TASK_PROPERTY.getProperty("OS");
        this.notiflag = this.TASK_PROPERTY.getProperty("NOTI_FLAG");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_AutoBaseSpoolTask");
        this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_BASE_SEND_LIST;
        this.SELECT_DIVIDE_TARGET_LIST_QUERY = QUERY_SELECT_BASE_DIVIDE_SEND_LIST;
        this.UPDATE_TARGET_LIST_QUERY = null;
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
        this.APPEND_TOTAL_SPOOL = false;
        this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
        this.SPOOL_ANALYZER.setSendType("AUTO");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("Y");
        this.SPOOL_ANALYZER.setLimitDate(this.TASK_PROPERTY.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(1)));
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setRowid(this.rowid);
        this.SPOOL_ANALYZER.setOs(this.os);
        this.SPOOL_ANALYZER.setNotiflag(this.notiflag);
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
        this.SPOOL_ANALYZER.setRowid(prop.getProperty("ROW_ID"));
        this.SPOOL_ANALYZER.setOs(prop.getProperty("OS"));
        this.SPOOL_ANALYZER.setNotiflag(prop.getProperty("NOTI_FLAG"));
        this.SPOOL_ANALYZER.setTokenID(prop.getProperty("TMS_M_TOKEN"));
        this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
        this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
        this.SPOOL_ANALYZER.setSecureFlag(prop.getProperty("SECURE_FLAG"));
        this.SPOOL_ANALYZER.setAdditionalValue(prop.getProperty("ADDITIONAL_INFO"));
        this.SPOOL_ANALYZER.setMapping(prop.getProperty("MAPPING"));
        this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.TASK_PROPERTY.getProperty("POST_ID"));
        this.mailSpoolInfo.setSendState(this.TASK_PROPERTY.getProperty("SEND_STATE"));
        this.mailSpoolInfo.setMappingHeader(this.getMappingHeader());
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        BasicDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new BasicDefaultMappingGenerator();
        __DEFAULT_MAPPING_GENERATOR__.process(this.TASK_PROPERTY);
        this.mailSpoolInfo.setDefaultMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping());
        this.mailSpoolInfo.setDefaultHashMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping());
        SpoolInfoManager.registSpoolInfo(this.mailSpoolInfo);
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Finish(boolean success) throws Exception {
        eMsStatement stmt = null;
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            Properties prop = new Properties();
            prop.setProperty("WORKDAY", this.TASK_PROPERTY.getProperty("WORKDAY"));
            prop.setProperty("SEQNO", this.TASK_PROPERTY.getProperty("SEQNO"));
            prop.setProperty("CHANNEL_TYPE", this.TASK_PROPERTY.getProperty("CHANNEL_TYPE"));
            prop.setProperty("SPOOL_CONF", SpoolInfoManager.getSpoolInfo(this.TASK_PROPERTY.getProperty("POST_ID")).getSpoolInfoPath());
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_SPOOL_CONF, prop, "${", "}", true, false);
            stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
        }
        finally {
            this.EMS_CONNECTION.recycleStatement(stmt);
        }
    }

    static {
        try {
            QUERY_UPDATE_STATE_START = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_START");
            QUERY_UPDATE_STATE_END = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_END");
            QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("COMMON", "QUERY_CHECK_STOP_FLAG");
            QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_INFO");
            QUERY_SELECT_BASE_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_SELECT_BASE_SEND_LIST");
            QUERY_SELECT_BASE_DIVIDE_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_SELECT_BASE_DIVIDE_SEND_LIST");
            QUERY_UPDATE_SPOOL_CONF = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SPOOL_CONF");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

