/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.util.recycle.ObjectPool;
import pluto.util.recycle.RecycleBin;
import pluto.util.recycle.Recycleable;

public class SampleWorker
extends Thread
implements Recycleable {
    private static final Logger log = LoggerFactory.getLogger(SampleWorker.class);
    private boolean alive = true;
    private boolean work = false;
    protected ObjectPool pool = null;

    public SampleWorker(ObjectPool p, String name) {
        super(name);
        this.pool = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        log.info(" execute from=>".concat(Thread.currentThread().getName()));
        this.work = true;
        SampleWorker sampleWorker = this;
        synchronized (sampleWorker) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.alive = true;
        SampleWorker sampleWorker = this;
        synchronized (sampleWorker) {
            this.notifyAll();
        }
        this.work();
        log.info(" is die.... ");
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        while (this.alive) {
            try {
                while (!this.work) {
                    SampleWorker sampleWorker = this;
                    synchronized (sampleWorker) {
                        this.wait(30000L);
                    }
                    if (this.alive) continue;
                    return;
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (!this.alive) {
                return;
            }
            try {
                log.debug(" WORK....... ");
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
            }
            catch (ThreadDeath death) {
                log.error(this.getName() + " is Death : " + death.toString());
                this.alive = false;
            }
            catch (Throwable error) {
                log.error(" is catch Throwable : " + error.toString());
            }
            if (!this.alive) {
                return;
            }
            this.recycle();
        }
    }

    @Override
    public void clean() {
        this.work = false;
    }

    @Override
    public void recycle() {
        this.clean();
        this.pool.recycle(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecycleBin(RecycleBin bin) {
        log.info(this.getName(), (Object)" setEnd from=>".concat(Thread.currentThread().getName()));
        this.alive = false;
        SampleWorker sampleWorker = this;
        synchronized (sampleWorker) {
            this.notifyAll();
        }
    }

    @Override
    public void destroy() {
        log.info(this.getName(), (Object)" destroy from=>".concat(Thread.currentThread().getName()));
        this.pool.destroy(this);
    }

    @Override
    public void setEnd() {
    }
}

