/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.convert;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;

public class BASE64 {
    private static final Logger log = LoggerFactory.getLogger(BASE64.class);
    public static final boolean DEBUG = false;
    private static final char[] BaseTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] ConvertBaseTable = new byte[256];
    private static final byte BLANK = 32;
    private static final byte TAB = 9;
    private static final byte CR = 13;
    private static final byte LF = 10;

    public static synchronized String encode(String src) {
        if (src.length() == 0) {
            return src;
        }
        byte[] source = null;
        try {
            source = src.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            source = src.getBytes();
        }
        return new String(BASE64.encode_base(source));
    }

    public static String encode(byte[] source) {
        return new String(BASE64.encode_base(source));
    }

    public static void encode_sep(byte[] __SOURCE__, int __LENGTH__, byte[] __TARGET__) {
        __LENGTH__ = __LENGTH__ > 3 ? 3 : __LENGTH__;
        switch (__LENGTH__) {
            case 1: {
                __TARGET__[0] = (byte)BaseTable[__SOURCE__[0] >>> 2 & 0x3F];
                __TARGET__[1] = (byte)BaseTable[(__SOURCE__[0] << 4 & 0x30) + 0];
                __TARGET__[2] = 61;
                __TARGET__[3] = 61;
                break;
            }
            case 2: {
                __TARGET__[0] = (byte)BaseTable[__SOURCE__[0] >>> 2 & 0x3F];
                __TARGET__[1] = (byte)BaseTable[(__SOURCE__[0] << 4 & 0x30) + (__SOURCE__[1] >>> 4 & 0xF)];
                __TARGET__[2] = (byte)BaseTable[(__SOURCE__[1] << 2 & 0x3C) + 0];
                __TARGET__[3] = 61;
                break;
            }
            case 3: {
                __TARGET__[0] = (byte)BaseTable[__SOURCE__[0] >>> 2 & 0x3F];
                __TARGET__[1] = (byte)BaseTable[(__SOURCE__[0] << 4 & 0x30) + (__SOURCE__[1] >>> 4 & 0xF)];
                __TARGET__[2] = (byte)BaseTable[(__SOURCE__[1] << 2 & 0x3C) + (__SOURCE__[2] >>> 6 & 3)];
                __TARGET__[3] = (byte)BaseTable[__SOURCE__[2] & 0x3F];
            }
        }
    }

    public static byte[] encode_base(byte[] source) {
        if (source == null || source.length == 0) {
            return source;
        }
        byte[] target = new byte[(source.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        for (int k = source.length; k > 0; k -= 3) {
            if (k == 1) {
                byte byte0 = source[i++];
                int l = 0;
                target[j++] = (byte)BaseTable[byte0 >>> 2 & 0x3F];
                target[j++] = (byte)BaseTable[(byte0 << 4 & 0x30) + (l >>> 4 & 0xF)];
                target[j++] = 61;
                target[j++] = 61;
                continue;
            }
            if (k == 2) {
                byte byte1 = source[i++];
                byte byte3 = source[i++];
                int i1 = 0;
                target[j++] = (byte)BaseTable[byte1 >>> 2 & 0x3F];
                target[j++] = (byte)BaseTable[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xF)];
                target[j++] = (byte)BaseTable[(byte3 << 2 & 0x3C) + (i1 >>> 6 & 3)];
                target[j++] = 61;
                continue;
            }
            byte byte2 = source[i++];
            byte byte4 = source[i++];
            byte byte5 = source[i++];
            target[j++] = (byte)BaseTable[byte2 >>> 2 & 0x3F];
            target[j++] = (byte)BaseTable[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xF)];
            target[j++] = (byte)BaseTable[(byte4 << 2 & 0x3C) + (byte5 >>> 6 & 3)];
            target[j++] = (byte)BaseTable[byte5 & 0x3F];
        }
        return target;
    }

    public static synchronized String decode(String src) {
        if (src == null || src.length() == 0) {
            return "";
        }
        return BASE64.decode(src.getBytes());
    }

    public static String decode(byte[] src) {
        return BASE64.decode(src, eMsLocale.CHAR_SET);
    }

    public static String decode(byte[] src, String charset) {
        try {
            return new String(BASE64.decode_base(src), charset);
        }
        catch (Exception e) {
            return new String(BASE64.decode_base(src));
        }
    }

    public static int decode_sep(byte[] __SOURCE__, byte[] __TARGET__) {
        if (__SOURCE__.length != 4) {
            throw new RuntimeException("INVAILD SIZE");
        }
        byte L1 = 0;
        byte L2 = 0;
        byte byte0 = ConvertBaseTable[__SOURCE__[0] & 0xFF];
        byte byte1 = ConvertBaseTable[__SOURCE__[1] & 0xFF];
        L1 = (byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3);
        if (__SOURCE__[2] == 61) {
            __TARGET__[0] = L1;
            return 1;
        }
        byte0 = byte1;
        byte1 = ConvertBaseTable[__SOURCE__[2] & 0xFF];
        L2 = (byte)(byte0 << 4 & 0xF0 | byte1 >>> 2 & 0xF);
        if (__SOURCE__[3] == 61) {
            __TARGET__[0] = L1;
            __TARGET__[1] = L2;
            return 2;
        }
        __TARGET__[0] = L1;
        __TARGET__[1] = L2;
        byte0 = byte1;
        byte1 = ConvertBaseTable[__SOURCE__[3] & 0xFF];
        __TARGET__[2] = (byte)(byte0 << 6 & 0xC0 | byte1 & 0x3F);
        return 3;
    }

    public static byte[] decode_base(byte[] source) {
        if (source.length == 0) {
            return source;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(source.length);
        int j = 0;
        while (j < source.length && source[j] != 0) {
            byte byte0 = ConvertBaseTable[source[j++] & 0xFF];
            byte byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 2 & 0xFC | byte1 >>> 4 & 3);
            if (source[j] == 61) break;
            byte0 = byte1;
            byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 4 & 0xF0 | byte1 >>> 2 & 0xF);
            if (source[j] == 61) break;
            byte0 = byte1;
            byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 6 & 0xC0 | byte1 & 0x3F);
        }
        byte[] returnValue = out.toByteArray();
        return returnValue;
    }

    public static void decodeToStream(byte[] source, OutputStream out) throws Exception {
        if (source == null || source.length == 0) {
            return;
        }
        int j = 0;
        while (j < source.length && source[j] != 0) {
            while (source[j] == 32 || source[j] == 9 || source[j] == 13 || source[j] == 10) {
                ++j;
            }
            byte byte0 = ConvertBaseTable[source[j++] & 0xFF];
            byte byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 2 & 0xFC | byte1 >>> 4 & 3);
            if (source[j] == 61) break;
            byte0 = byte1;
            byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 4 & 0xF0 | byte1 >>> 2 & 0xF);
            if (source[j] == 61) break;
            byte0 = byte1;
            byte1 = ConvertBaseTable[source[j++] & 0xFF];
            out.write(byte0 << 6 & 0xC0 | byte1 & 0x3F);
        }
    }

    public static void main(String[] args) {
        String s = "TV9JRD1pZDU=&U1RZUEU9Q0FNUA==&TElTVF9UQUJMRT1UTVNfRU1BSUxfTElTVF8wNw==&UE9TVF9JRD0yMDEzMDcxNzAwMDA0&U0VSVkVSX0lEPTAx&VEM9MjAxMzA3Mjk=&S0lORD1P";
        log.debug(BASE64.decode(s));
    }

    static {
        for (int i = 0; i < 255; ++i) {
            BASE64.ConvertBaseTable[i] = -1;
        }
        for (int j = 0; j < BaseTable.length; ++j) {
            BASE64.ConvertBaseTable[BASE64.BaseTable[j]] = (byte)j;
        }
    }
}

