/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import freemarker20.template.SimpleHash;
import freemarker20.template.TemplateModel;
import freemarker20.tm.TemplateHashModelData;
import freemarker20.tm.TemplateHashModelListTM;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsStringWriter;
import pluto.lang.ByteArrayContainer;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;

public class StringConvertUtil {
    private static eMsStringWriter INNER_EXCEPTION_PROCESS_STRING_WRITER = null;
    private static PrintWriter INNER_EXCEPTION_PROCESS_PRINT_WRITER = null;

    public static final void ConvertString(StringBuffer tmpBuffer, String src, Object MAP, String start, String end, Object MAP2, String start2, String end2, boolean query, boolean empty) {
        if (src == null) {
            return;
        }
        if (MAP == null) {
            tmpBuffer.append(src);
            return;
        }
        Map map = null;
        Properties mapProperty = null;
        if (MAP instanceof Properties) {
            mapProperty = (Properties)MAP;
        } else if (MAP instanceof Map) {
            map = (Map)MAP;
        } else if (MAP instanceof SimpleHash) {
            map = ((SimpleHash)MAP).getAsHashmap();
        }
        if (map == null && mapProperty == null) {
            throw new RuntimeException("UNSUPPORTED HASH TYPE");
        }
        boolean secondMappingFlag = MAP2 != null && start2 != null && end2 != null;
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        String value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            if (key.startsWith("util.")) {
                try {
                    value = StringUtil.getStringUtilMethodResult(key, map == null ? mapProperty : map);
                }
                catch (Throwable thw) {
                    value = "<!-- " + thw.toString() + "-->";
                }
            } else {
                value = map == null ? mapProperty.getProperty(key) : map.get(key);
            }
            tmpBuffer.append(src.substring(idx3, idx1));
            if (value == null) {
                if (empty) {
                    tmpBuffer.append(start);
                    tmpBuffer.append(key);
                    tmpBuffer.append(end);
                }
            } else if (query) {
                StringConvertUtil.ConvertString(tmpBuffer, value.toString(), "'", "''");
            } else if (secondMappingFlag) {
                StringConvertUtil.ConvertString(tmpBuffer, value.toString(), MAP2, start2, end2, query, empty);
            } else {
                tmpBuffer.append(value.toString());
            }
            idx3 = idx2 + end.length();
        }
        tmpBuffer.append(src.substring(idx3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String ConvertString(String src, Object MAP, String start, String end, boolean query, boolean empty) {
        StringBuffer tmpBuffer = null;
        try {
            tmpBuffer = new StringBuffer(512);
            StringConvertUtil.ConvertString(tmpBuffer, src, MAP, start, end, query, empty);
            String string = tmpBuffer.toString();
            return string;
        }
        finally {
            tmpBuffer = null;
        }
    }

    public static final void ConvertString(StringBuffer tmpBuffer, String src, Object MAP, String start, String end, boolean query, boolean empty) {
        if (src == null) {
            return;
        }
        if (MAP == null) {
            tmpBuffer.append(src);
            return;
        }
        Map map = null;
        if (MAP instanceof Properties) {
            StringConvertUtil.ConvertString(tmpBuffer, src, (Properties)MAP, start, end, query, empty);
            return;
        }
        if (MAP instanceof Map) {
            map = (Map)MAP;
        } else if (MAP instanceof SimpleHash) {
            map = ((SimpleHash)MAP).getAsHashmap();
        } else {
            throw new RuntimeException("UNSUPPORTED HASH TYPE");
        }
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        Object value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            value = map.get(key);
            tmpBuffer.append(src.substring(idx3, idx1));
            if (value == null) {
                if (empty) {
                    tmpBuffer.append(start);
                    tmpBuffer.append(key);
                    tmpBuffer.append(end);
                }
            } else if (query) {
                StringConvertUtil.ConvertString(tmpBuffer, value.toString(), "'", "''");
            } else {
                tmpBuffer.append(value.toString());
            }
            idx3 = idx2 + end.length();
        }
        tmpBuffer.append(src.substring(idx3));
    }

    public static final void ConvertString(StringBuffer tmpBuffer, String src, Properties map, String start, String end, boolean query, boolean empty) {
        if (src == null) {
            return;
        }
        if (map == null) {
            tmpBuffer.append(src);
            return;
        }
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        String value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            value = map.getProperty(key);
            tmpBuffer.append(src.substring(idx3, idx1));
            if (value == null) {
                if (empty) {
                    tmpBuffer.append(start);
                    tmpBuffer.append(key);
                    tmpBuffer.append(end);
                }
            } else if (query) {
                StringConvertUtil.ConvertString(tmpBuffer, value.toString(), "'", "''");
            } else {
                tmpBuffer.append(value.toString());
            }
            idx3 = idx2 + end.length();
        }
        tmpBuffer.append(src.substring(idx3));
    }

    public static final void ConvertString(StringBuffer tmpBuffer, String source, String target, String dest) {
        if (source == null) {
            return;
        }
        int idx1 = 0;
        int idx2 = 0;
        while ((idx1 = source.indexOf(target, idx2)) >= 0) {
            tmpBuffer.append(source.substring(idx2, idx1));
            tmpBuffer.append(dest);
            idx2 = idx1 + target.length();
        }
        tmpBuffer.append(source.substring(idx2));
    }

    public static final String ConvertStreamToString(InputStream in, String enc) throws Exception {
        String bytes22;
        eMsByteArrayOutputStream __BUFFER__ = null;
        byte[] buffer = null;
        try {
            int bytes22;
            __BUFFER__ = eMsByteArrayOutputStream.getInstance();
            __BUFFER__.flush();
            __BUFFER__.reset();
            buffer = ByteArrayContainer.getInstance();
            while ((bytes22 = in.read(buffer)) >= 0) {
                __BUFFER__.write(buffer, 0, bytes22);
            }
            __BUFFER__.flush();
            bytes22 = enc == null ? __BUFFER__.toString() : __BUFFER__.toString(enc);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ByteArrayContainer.recycleInstance(buffer);
                eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
                throw throwable;
            }
        }
        ByteArrayContainer.recycleInstance(buffer);
        eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
        return bytes22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GeneralizeMailContents(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer tmpBuffer = null;
        BufferedReader b = null;
        try {
            tmpBuffer = new StringBuffer(512);
            tmpBuffer.setLength(0);
            b = new BufferedReader(new StringReader(src));
            String tmp = null;
            while (b.ready() && (tmp = b.readLine()) != null) {
                if ((tmp = tmp.trim()).startsWith(".")) {
                    tmpBuffer.append(".");
                }
                if (tmp.length() <= 0) continue;
                if (tmp.equals(".")) {
                    tmpBuffer.append(".");
                }
                tmpBuffer.append(tmp);
                tmpBuffer.append("\r\n");
            }
            String string = tmpBuffer.toString();
            return string;
        }
        catch (Exception e) {
            String string = src;
            return string;
        }
        finally {
            tmpBuffer = null;
            try {
                b.close();
            }
            catch (Exception e) {}
        }
    }

    public static final void ConvertMapToString(StringBuffer tmpBuffer, Properties prop) {
        if (prop == null) {
            return;
        }
        Enumeration<?> eNum = prop.propertyNames();
        while (eNum.hasMoreElements()) {
            String key = eNum.nextElement().toString();
            tmpBuffer.append("[");
            tmpBuffer.append(key);
            tmpBuffer.append("|");
            DelimConvertor.encodeToBuffer(tmpBuffer, prop.getProperty(key));
            tmpBuffer.append("]");
        }
    }

    public static final void ConvertStringToSimpleHash(SimpleHash _MEMBER_HASH_, String mapping) {
        if (mapping == null) {
            return;
        }
        int idx_start = mapping.indexOf("&LIST&");
        int idx_end = -1;
        int loop_index = 1;
        if (idx_start > 0) {
            StringConvertUtil.ConvertStringToSimpleHashSimple(_MEMBER_HASH_, mapping, 0, idx_start);
            while ((idx_end = mapping.indexOf("&LIST&", idx_start + 1)) >= 0) {
                StringConvertUtil.ConvertStringToSimpleHashLoop(_MEMBER_HASH_, "rap_" + String.valueOf(loop_index++), mapping, idx_start, idx_end);
                idx_start = idx_end;
            }
            StringConvertUtil.ConvertStringToSimpleHashLoop(_MEMBER_HASH_, "rap_" + String.valueOf(loop_index++), mapping, idx_start, mapping.length());
        } else {
            StringConvertUtil.ConvertStringToSimpleHashSimple(_MEMBER_HASH_, mapping, 0, mapping.length());
        }
    }

    public static final void ConvertStringToSimpleHashLoop(SimpleHash _MEMBER_HASH_, String loop_index, String mapping, int start, int end) {
        int idxStart = 0;
        int idxEnd = start;
        TemplateHashModelListTM myMapping = new TemplateHashModelListTM();
        while ((idxStart = mapping.indexOf("{", idxEnd)) >= 0 && idxStart <= end && (idxEnd = mapping.indexOf("}", idxStart)) >= 0) {
            StringConvertUtil.putStringToVarList(myMapping, mapping, idxStart + 1, idxEnd);
        }
        _MEMBER_HASH_.put(loop_index, (TemplateModel)myMapping);
    }

    private static final void putStringToVarList(TemplateHashModelListTM myMapping, String mapping, int start, int end) {
        int idxStart = 0;
        int idxMiddle = 0;
        int idxEnd = start;
        TemplateHashModelData data = new TemplateHashModelData();
        while ((idxStart = mapping.indexOf("[", idxEnd)) >= 0 && idxStart <= end && (idxMiddle = mapping.indexOf("|", idxStart)) >= 0 && (idxEnd = mapping.indexOf("]", idxMiddle)) >= 0) {
            data.put(mapping.substring(idxStart + 1, idxMiddle), DelimConvertor.decode(mapping.substring(idxMiddle + 1, idxEnd)));
        }
        myMapping.addEntry((Object)data);
    }

    public static final void ConvertStringToSimpleHashSimple(SimpleHash _MEMBER_HASH_, String mapping, int start, int end) {
        int idxStart = 0;
        int idxMiddle = 0;
        int idxEnd = start;
        while ((idxStart = mapping.indexOf("[", idxEnd)) >= 0 && idxStart <= end && (idxMiddle = mapping.indexOf("|", idxStart)) >= 0 && (idxEnd = mapping.indexOf("]", idxMiddle)) >= 0) {
            _MEMBER_HASH_.put(mapping.substring(idxStart + 1, idxMiddle), DelimConvertor.decode(mapping.substring(idxMiddle + 1, idxEnd)));
        }
    }

    public static final void ConvertStringToProperty(Properties _MEMBER_HASH_, String mapping) {
        if (mapping == null) {
            return;
        }
        int idxStart = 0;
        int idxMiddle = 0;
        int idxEnd = 0;
        while ((idxStart = mapping.indexOf("[", idxEnd)) >= 0 && (idxMiddle = mapping.indexOf("|", idxStart)) >= 0 && (idxEnd = mapping.indexOf("]", idxMiddle)) >= 0) {
            _MEMBER_HASH_.setProperty(mapping.substring(idxStart + 1, idxMiddle), mapping.substring(idxMiddle + 1, idxEnd));
        }
    }

    public static String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return StringConvertUtil.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    public static void LeftPadding(StringBuffer tmpBuffer, String src, char padding, int size) {
        if (src == null) {
            src = "";
        }
        for (int i = size - src.length(); i > 0; --i) {
            tmpBuffer.append(padding);
        }
        tmpBuffer.append(src);
    }

    public static final String trimNull(Object src) {
        if (src == null) {
            return "";
        }
        return src.toString().trim();
    }

    public static final String exToString(Throwable ex) {
        return StringConvertUtil.exToString(null, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String exToString(String name, Throwable ex) {
        try {
            eMsStringWriter eMsStringWriter2 = INNER_EXCEPTION_PROCESS_STRING_WRITER;
            synchronized (eMsStringWriter2) {
                INNER_EXCEPTION_PROCESS_STRING_WRITER.reset();
                if (name != null) {
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write(name);
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.println("=>");
                }
                ex.printStackTrace(INNER_EXCEPTION_PROCESS_PRINT_WRITER);
                if (ex instanceof SQLException) {
                    SQLException sex = (SQLException)ex;
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write("ErrorCode:");
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write(String.valueOf(sex.getErrorCode()));
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write("\r\n");
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write("SqlState:");
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write(sex.getSQLState());
                    INNER_EXCEPTION_PROCESS_PRINT_WRITER.write("\r\n");
                }
                return INNER_EXCEPTION_PROCESS_STRING_WRITER.toString();
            }
        }
        catch (Throwable e) {
            return ex.toString();
        }
    }

    static {
        INNER_EXCEPTION_PROCESS_STRING_WRITER = new eMsStringWriter();
        INNER_EXCEPTION_PROCESS_PRINT_WRITER = new PrintWriter(INNER_EXCEPTION_PROCESS_STRING_WRITER);
    }
}

