/*
 * Decompiled with CFR 0.152.
 */
package pluto.schedule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.schedule.Task;

public class TaskWorker
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TaskWorker.class);
    private Task work = null;

    protected TaskWorker(ThreadGroup group, Task target) {
        super(group, target.getTaskID() + "'s Worker");
        this.work = target;
    }

    @Override
    public final void run() {
        if (log.isDebugEnabled()) {
            log.debug("START " + this.getName());
        }
        try {
            this.work.internal_execute();
        }
        catch (Throwable error) {
            log.error(this.getName(), error);
        }
        if (log.isDebugEnabled()) {
            log.debug("END " + this.getName());
        }
    }
}

