/*
 * Decompiled with CFR 0.152.
 */
package pluto.schedule;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.NoIDTaskRegistException;
import pluto.schedule.ScheduledMonitor;
import pluto.schedule.Task;
import pluto.schedule.TaskWorker;

public class TaskManager
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    public static ThreadGroup taskThreadGroup = new ThreadGroup(eMsLocale.EMS_ROOT_THREAD_GROUP, "TaskThreadGroup");
    public static final String KEY_WORKER_SIZE = "worker.size";
    public static final String KEY_CHECK_INTERVAL = "check.interval";
    public static int TASK_THREAD_NUM = 0;
    public static final int DEFAULT_WORKER_SIZE = 10;
    public static final long DEFAULT_CHECK_INTERVAL = 30000L;
    private static Object __INNER_LOCK__ = new Object();
    private static boolean init_flag = false;
    private static NoIDTaskRegistException __NO_ID_EXCEPTION__ = new NoIDTaskRegistException();
    private List<Task> taskList = new LinkedList<Task>();
    private static TaskManager singleTaskManager;

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        int size = 10;
        long inter = 30000L;
        try {
            size = Integer.parseInt(tmp.getProperty(KEY_WORKER_SIZE));
        }
        catch (Exception ignore) {
            log.error("error", (Throwable)ignore);
        }
        try {
            inter = Integer.parseInt(tmp.getProperty(KEY_CHECK_INTERVAL));
        }
        catch (Exception ignore) {
            log.error("error", (Throwable)ignore);
        }
        ++TASK_THREAD_NUM;
        singleTaskManager = new TaskManager(size, inter);
        singleTaskManager.start();
        init_flag = true;
    }

    public static void unload() throws Exception {
        if (singleTaskManager != null) {
            singleTaskManager.close();
        }
    }

    private TaskManager(int size, long check_interval) {
        super(check_interval, "TaskManager" + TASK_THREAD_NUM);
        this.setName("TaskManager" + TASK_THREAD_NUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void executeTask(Task work) throws NoIDTaskRegistException, AlreadyRegistTaskException {
        if (!init_flag) {
            throw new RuntimeException("TaskManager is not Initialized... First init TaskManager");
        }
        Object object = __INNER_LOCK__;
        synchronized (object) {
            String __TARGET_TASK_ID__ = work.getTaskID();
            log.debug("[CURRENT TASK]=" + __TARGET_TASK_ID__);
            if (__TARGET_TASK_ID__ == null) {
                throw __NO_ID_EXCEPTION__;
            }
            int i = 0;
            for (Task __CHECK_TASK__ : TaskManager.singleTaskManager.taskList) {
                ++i;
                if (!__TARGET_TASK_ID__.equals(__CHECK_TASK__.getTaskID())) continue;
                log.info("CURRENT TASK=" + __TARGET_TASK_ID__ + " [" + i + "]TASK=" + __CHECK_TASK__.getTaskID());
                throw new AlreadyRegistTaskException(__TARGET_TASK_ID__ + " is already regist");
            }
            singleTaskManager.getTaskList().add(work);
            if (singleTaskManager.timeToStart(work)) {
                TaskWorker tmpWorker = new TaskWorker(taskThreadGroup, work);
                tmpWorker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isRegistTask(Task work) {
        if (!init_flag) {
            throw new RuntimeException("TaskManager is not Initialize... First init TaskManager");
        }
        Object object = __INNER_LOCK__;
        synchronized (object) {
            String __TARGET_TASK_ID__ = work.getTaskID();
            if (__TARGET_TASK_ID__ == null) {
                return true;
            }
            for (Task __CHECK_TASK__ : singleTaskManager.getTaskList()) {
                if (!__TARGET_TASK_ID__.equals(__CHECK_TASK__.getTaskID())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isRegistTask(String __TARGET_TASK_ID__) {
        if (!init_flag) {
            throw new RuntimeException("TaskManager is not Initialize... First init TaskManager");
        }
        Object object = __INNER_LOCK__;
        synchronized (object) {
            if (__TARGET_TASK_ID__ == null) {
                return true;
            }
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug("CHECK ID", (Object)__TARGET_TASK_ID__);
            }
            for (Task __CHECK_TASK__ : singleTaskManager.getTaskList()) {
                if (log.isDebugEnabled()) {
                    log.debug("REGIST CHECK", (Object)__CHECK_TASK__.getTaskID());
                }
                if (!__TARGET_TASK_ID__.equals(__CHECK_TASK__.getTaskID())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTaskNames() {
        StringBuffer buffer = new StringBuffer(128);
        singleTaskManager.getInternalTaskNames(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInternalTaskNames(StringBuffer __BUFFER__) {
        Object object = __INNER_LOCK__;
        synchronized (object) {
            Iterator<Task> it = this.getTaskList().iterator();
            while (it.hasNext()) {
                __BUFFER__.append(((Object)it.next()).toString());
                __BUFFER__.append("\r\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() throws Exception {
        Object object = __INNER_LOCK__;
        synchronized (object) {
            boolean start_flag = false;
            Iterator<Task> iter = this.taskList.iterator();
            while (iter.hasNext()) {
                TaskWorker worker;
                Task task = iter.next();
                start_flag = task.isStarted();
                if (start_flag) {
                    if (task.isEnd()) {
                        log.debug("{} is destroy ", (Object)task.getTaskID());
                        task.destroy();
                        iter.remove();
                        continue;
                    }
                    if (task.isValidTime()) {
                        log.debug(task.getName(), (Object)" valid time... so execute...");
                        worker = new TaskWorker(taskThreadGroup, task);
                        worker.start();
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug(task.getName(), (Object)" not valid time... so skip...");
                    continue;
                }
                if (!this.timeToStart(task)) continue;
                worker = new TaskWorker(taskThreadGroup, task);
                worker.start();
            }
        }
    }

    private boolean timeToStart(Task task) {
        boolean check_result = false;
        for (Task tmpTask2 : this.taskList) {
            if (!(check_result = check_result || task.depends(tmpTask2.getTaskID()))) continue;
        }
        return !check_result;
    }

    public List<Task> getTaskList() {
        return this.taskList;
    }
}

