/*
 * Decompiled with CFR 0.152.
 */
package pluto.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsFileWriter;
import pluto.lang.Name;
import pluto.util.Cal;

public abstract class Task
extends Name {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    public static final short TYPE_TRANSACTION = 1;
    public static final short TYPE_INTERVAL = 2;
    public static final long DEFAULT_EXECUTE_INTERVAL = 60000L;
    protected boolean work_flag = true;
    protected boolean start_flag = false;
    protected long next_execute_time = -1L;
    protected List<String> dependsList = new ArrayList<String>();
    protected Properties TASK_PROPERTY = null;
    private short TASK_TYPE = 1;
    private long TASK_EXEC_INTERVAL = 60000L;
    private String TASK_ID = "1";
    protected eMsFileWriter LOG_CHANNEL = null;

    protected Task() {
        this(1, 60000L);
    }

    protected Task(short type) {
        this(type, 60000L);
    }

    protected Task(short type, long interval) {
        this.TASK_TYPE = type;
        this.TASK_EXEC_INTERVAL = interval;
    }

    public final void setExecutionType(short type, String interval) {
        this.TASK_TYPE = type;
        try {
            this.TASK_EXEC_INTERVAL = Long.parseLong(interval);
        }
        catch (Exception ignore) {
            this.TASK_EXEC_INTERVAL = 60000L;
        }
    }

    public final void setExecutionType(short type, long interval) {
        this.TASK_TYPE = type;
        this.TASK_EXEC_INTERVAL = interval;
    }

    protected final void setLogWrtier(eMsFileWriter out) {
        this.LOG_CHANNEL = out;
    }

    public void log(String logStr) {
        if (this.LOG_CHANNEL == null) {
            log.debug(logStr);
            return;
        }
        try {
            this.LOG_CHANNEL.write(Cal.getDate());
            this.LOG_CHANNEL.write("\t");
            this.LOG_CHANNEL.println(logStr);
        }
        catch (Throwable e) {
            log.error("error", e);
        }
    }

    public void log(Throwable thw) {
        if (this.LOG_CHANNEL == null) {
            log.error("default logging:", thw);
            return;
        }
        try {
            this.LOG_CHANNEL.print(Cal.getDate());
            this.LOG_CHANNEL.print(" ---- STACK TRACE ----");
            this.LOG_CHANNEL.println();
        }
        catch (Throwable e) {
            log.error("log write error", e);
        }
    }

    public void setTaskID(String ID) {
        if (ID != null && !"".equals(ID)) {
            this.TASK_ID = ID;
        }
    }

    public String getTaskID() {
        return this.TASK_ID;
    }

    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setTaskID(this.TASK_PROPERTY.getProperty("TASK_ID"));
        this.setName(this.TASK_PROPERTY.getProperty("TASK_NAME"));
    }

    public void setDependsList(List<String> list) {
        this.dependsList = list == null ? new ArrayList<String>() : list;
    }

    public boolean depends(String taskId) {
        return this.dependsList == null ? false : this.dependsList.contains(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_execute() {
        long startTime = System.currentTimeMillis();
        this.start_flag = true;
        this.work_flag = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] execute_initiate start", (Object)this.getName());
            }
            this.execute_initiate();
            if (log.isDebugEnabled()) {
                log.debug("[{}] execute_initiate end", (Object)this.getName());
            }
        }
        catch (Throwable thw) {
            log.error("[{}], execute_initiate error", (Object)this.getName(), (Object)thw);
            this.execute_initiateError(thw);
            this.release_Resource();
            this.setEnd();
            return;
        }
        try {
            this.execute();
            this.doSuccessProcess();
        }
        catch (Throwable thw) {
            log.error("[{}], execute error", (Object)this.getName(), (Object)thw);
            this.doErrorProcess(thw);
        }
        finally {
            long elapseTime = System.currentTimeMillis() - startTime;
            if (elapseTime > 5000L) {
                log.info("{} execute  [elapseTime:{} ms]", (Object)this.getTaskID(), (Object)elapseTime);
            }
            this.release_Resource();
            this.setEnd();
        }
    }

    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
    }

    public void doSuccessProcess() {
    }

    public final boolean isEnd() {
        if (this.TASK_TYPE == 2) {
            return false;
        }
        return !this.work_flag;
    }

    public final boolean isStarted() {
        return this.start_flag;
    }

    private void setEnd() {
        if (this.LOG_CHANNEL != null) {
            this.LOG_CHANNEL.close();
        }
        this.work_flag = false;
        if (this.TASK_TYPE == 2) {
            this.next_execute_time = System.currentTimeMillis() + this.TASK_EXEC_INTERVAL;
        }
    }

    public boolean isValidTime() {
        if (this.TASK_TYPE == 1) {
            return false;
        }
        if (this.next_execute_time < 0L) {
            return false;
        }
        return !this.work_flag && System.currentTimeMillis() > this.next_execute_time;
    }

    public short getType() {
        return 2;
    }

    public void destroy() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract void execute() throws Exception;

    public void execute_initiate() throws Exception {
    }

    public abstract void execute_initiateError(Throwable var1);

    public abstract void release_Resource();
}

