/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.net.NetworkMonitorable;
import pluto.net.SocketAgent;
import pluto.schedule.ScheduledMonitor;

public class SocketAgentMonitor
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(SocketAgentMonitor.class);
    private static Object lock = new Object();
    private static List ContainThreads = new LinkedList();
    private static SocketAgentMonitor innerManager = null;
    private static Object[] TMP_AGENT_ARRAY = null;

    private SocketAgentMonitor(long a) {
        super(a, "SocketAgentMonitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registSocketAgent(NetworkMonitorable target) {
        if (innerManager == null) {
            innerManager = new SocketAgentMonitor(eMsLocale.SMTP_AGENT_IDLE_CHECK_INTERVAL);
            innerManager.start();
        }
        Object object = lock;
        synchronized (object) {
            if (ContainThreads.contains(target)) {
                return false;
            }
            return ContainThreads.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSocketAgent(SocketAgent target) {
        Object object = lock;
        synchronized (object) {
            return ContainThreads.remove(target);
        }
    }

    public static void destroy() {
        if (innerManager != null) {
            innerManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() {
        if (log.isDebugEnabled()) {
            log.debug("Check IDLE Agent..");
        }
        Object object = lock;
        synchronized (object) {
            TMP_AGENT_ARRAY = TMP_AGENT_ARRAY == null ? ContainThreads.toArray() : ContainThreads.toArray(TMP_AGENT_ARRAY);
        }
        int size = ContainThreads.size();
        for (int i = 0; i < size; ++i) {
            NetworkMonitorable target = (NetworkMonitorable)TMP_AGENT_ARRAY[i];
            if (!target.isIdle()) continue;
            log.info("IDLE AGENT FOUND", (Object)target.getConnectHost());
            target.killSession();
            log.info("IDLE AGENT KILL SESSION", (Object)target.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Check IDLE Agent..[END]");
        }
    }
}

