/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetAddress {
    private static final Logger log = LoggerFactory.getLogger(NetAddress.class);

    public static final InetAddress getInetAddress(String addr) throws UnknownHostException {
        byte[] returnValue = NetAddress.getByteArray(addr);
        return returnValue == null ? null : InetAddress.getByAddress(returnValue);
    }

    public static final byte[] getByteArray(String addr) {
        int idx2;
        byte[] returnValue = new byte[4];
        int idx1 = addr.indexOf(46);
        if (idx1 < 0) {
            log.info("getRawAddr() FIND FIRST INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[0] = (byte)(Integer.parseInt(addr.substring(0, idx1)) & 0xFF);
        if ((idx2 = addr.indexOf(46, ++idx1)) < 0) {
            log.error("getRawAddr() FIND SECOND INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[1] = (byte)(Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);
        idx1 = idx2 + 1;
        if ((idx2 = addr.indexOf(46, idx1)) < 0) {
            log.error("getRawAddr() FIND THIRD INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[2] = (byte)(Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);
        returnValue[3] = (byte)(Integer.parseInt(addr.substring(idx2 + 1)) & 0xFF);
        return returnValue;
    }

    public static final int[] getIntArray(String addr) {
        int idx2;
        int[] returnValue = new int[4];
        int idx1 = addr.indexOf(46);
        if (idx1 < 0) {
            log.info("getRawAddr() FIND FIRST INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[0] = Integer.parseInt(addr.substring(0, idx1));
        if ((idx2 = addr.indexOf(46, ++idx1)) < 0) {
            log.info("getRawAddr() FIND SECOND INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[1] = Integer.parseInt(addr.substring(idx1, idx2));
        idx1 = idx2 + 1;
        if ((idx2 = addr.indexOf(46, idx1)) < 0) {
            log.info("getRawAddr() FIND THIRD INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[2] = Integer.parseInt(addr.substring(idx1, idx2));
        returnValue[3] = Integer.parseInt(addr.substring(idx2 + 1));
        return returnValue;
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }
}

