/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.util.Hashtable;
import pluto.lang.eMsLocale;

public class BlackListContainer {
    private static Hashtable BLACK_LIST = null;
    private static int MAX_REJECT_COUNT = 100;
    private static long BLACK_LIST_REJECT_INTERVAL = eMsLocale.BLACK_LIST_REJECT_INTERVAL;

    public static synchronized void registBlackListDomain(String domain) {
        BlackListInfo info = (BlackListInfo)BLACK_LIST.get(domain);
        if (info == null) {
            info = new BlackListInfo(domain);
            BLACK_LIST.put(domain, info);
            return;
        }
        info.refresh();
    }

    public static synchronized boolean isBlackListDomain(String domain) {
        if (domain == null) {
            return false;
        }
        BlackListInfo info = (BlackListInfo)BLACK_LIST.get(domain);
        if (info != null) {
            return info.isRejectTime();
        }
        return false;
    }

    static {
        BLACK_LIST = new Hashtable();
    }

    static class BlackListInfo {
        long currentTime = -1L;
        int iRejectCount = 0;
        String id = null;

        BlackListInfo(String domain) {
            this.id = domain;
            this.refresh();
        }

        String getID() {
            return this.id;
        }

        void refresh() {
            this.currentTime = System.currentTimeMillis() + BLACK_LIST_REJECT_INTERVAL;
            this.iRejectCount = 0;
        }

        boolean isRejectTime() {
            if (this.currentTime > System.currentTimeMillis()) {
                ++this.iRejectCount;
                if (MAX_REJECT_COUNT < this.iRejectCount) {
                    this.iRejectCount = 0;
                    this.currentTime = System.currentTimeMillis() - 1L;
                }
            }
            return this.currentTime > System.currentTimeMillis();
        }
    }
}

