/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.mail.mx.DNSInputStream;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXSearchResult;
import pluto.mail.mx.exception.CanonicalNameFoundException;
import pluto.mail.mx.exception.NoMXRecordFoundException;
import pluto.net.NetAddress;

public class MXResultSorter {
    private static final Logger log = LoggerFactory.getLogger(MXResultSorter.class);
    static final CanonicalNameFoundException CANONICAL_NAME_FOUND_EXCEPTION = new CanonicalNameFoundException("final");
    long serial = -1L;
    long ttl = -1L;
    int minref = -1;
    String SOA_MASTER_DNS = null;
    String NORMAL_DNS = null;
    int SOA_MASTER_DNS_IP = 0;
    boolean exactSOA = false;
    protected Entry header = new Entry("header", -1, null, null);
    boolean hasCanonicalName = false;
    public int minMxCount = 0;
    public int etcMxCount = 0;

    public MXResultSorter() {
        this.header.next = this.header.previous = this.header;
    }

    public synchronized void putMailExchanger(DNSInputStream dnsIn) throws IOException {
        int preference = dnsIn.readShort();
        String mx = dnsIn.readDomainName();
        this.addMailExchanger(mx, preference);
    }

    public synchronized void putAddress(String domain, DNSInputStream dnsIn) throws IOException {
        int i1 = dnsIn.readByte();
        int i2 = dnsIn.readByte();
        int i3 = dnsIn.readByte();
        int i4 = dnsIn.readByte();
        this.addAddress(domain, LookupUtil.getIntIPToInetInt(i1, i2, i3, i4));
    }

    public synchronized void putStartOfAuth(DNSInputStream dnsIn) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("MXResultSorter put SOA");
        }
        this.SOA_MASTER_DNS = dnsIn.readDomainName();
        if (log.isDebugEnabled()) {
            log.debug("origin:" + this.SOA_MASTER_DNS);
        }
        if (log.isDebugEnabled()) {
            String mailAddress = dnsIn.readDomainName();
            log.debug("mailAddress:" + mailAddress);
        } else {
            dnsIn.readDomainName();
        }
        this.serial = dnsIn.readInt();
        if (log.isDebugEnabled()) {
            log.debug("serial:" + this.serial);
        }
        if (log.isDebugEnabled()) {
            long refresh = dnsIn.readInt();
            log.debug("refresh:" + refresh);
        } else {
            dnsIn.readInt();
        }
        if (log.isDebugEnabled()) {
            long retry = dnsIn.readInt();
            log.debug("retry:" + retry);
        } else {
            dnsIn.readInt();
        }
        if (log.isDebugEnabled()) {
            long expire = dnsIn.readInt();
            log.debug("expire:" + expire);
        } else {
            dnsIn.readInt();
        }
        this.ttl = dnsIn.readInt();
        if (log.isDebugEnabled()) {
            log.debug("ttl:" + this.ttl);
        }
    }

    public synchronized void addNameServer(String domain) {
        this.NORMAL_DNS = domain;
        if (this.NORMAL_DNS.equalsIgnoreCase(this.SOA_MASTER_DNS)) {
            this.exactSOA = true;
        }
    }

    public synchronized void addAddress(String domain, int iIP) {
        if (this.SOA_MASTER_DNS != null && domain.equalsIgnoreCase(this.SOA_MASTER_DNS)) {
            this.SOA_MASTER_DNS_IP = iIP;
        }
        if (domain == null) {
            if (log.isDebugEnabled()) {
                throw new RuntimeException("DOMAIN IS NULL");
            }
            return;
        }
        Entry nextEntry = this.header.next;
        while (nextEntry != this.header) {
            if (domain.equalsIgnoreCase(nextEntry.domain)) {
                nextEntry.listArecord.add(iIP);
                return;
            }
            nextEntry = nextEntry.next;
        }
        return;
    }

    public boolean hasCanonical() {
        return this.hasCanonicalName;
    }

    public void clearCanonical() {
        this.hasCanonicalName = false;
    }

    public synchronized void addCanonicalName(String fromDomain, String toDomain) {
        if (fromDomain.equalsIgnoreCase(toDomain)) {
            return;
        }
        this.hasCanonicalName = true;
        Entry targetEntry = null;
        Entry sourceEntry = null;
        Entry nextEntry = this.header.next;
        while (nextEntry != this.header) {
            if (nextEntry.domain.equalsIgnoreCase(toDomain)) {
                targetEntry = nextEntry;
            }
            if (nextEntry.domain.equalsIgnoreCase(fromDomain)) {
                sourceEntry = nextEntry;
            }
            nextEntry = nextEntry.next;
        }
        if (sourceEntry == null) {
            MXResultSorter.log("HAS CANONICAL BUT SOURCE ENTRY IS NULL");
            return;
        }
        if (targetEntry != null) {
            if (targetEntry.preference < sourceEntry.preference) {
                sourceEntry.next.previous = sourceEntry.previous;
                sourceEntry.previous.next = sourceEntry.next;
                sourceEntry.destroy();
            } else {
                targetEntry.next.previous = targetEntry.previous;
                targetEntry.previous.next = targetEntry.next;
                targetEntry.destroy();
            }
            throw CANONICAL_NAME_FOUND_EXCEPTION;
        }
        sourceEntry.domain = toDomain;
    }

    public synchronized void addMailExchanger(String domain, int preference) {
        if (domain == null) {
            if (log.isDebugEnabled()) {
                throw new RuntimeException("DOMAIN IS NULL");
            }
            return;
        }
        Entry nextEntry = this.header.next;
        while (true) {
            if (nextEntry == this.header || preference < nextEntry.preference) {
                Entry newEntry;
                newEntry.previous.next = newEntry = new Entry(domain, preference, nextEntry, nextEntry.previous);
                newEntry.next.previous = newEntry;
                return;
            }
            nextEntry = nextEntry.next;
        }
    }

    public void clear() {
        this.serial = -1L;
        this.minref = -1;
        this.SOA_MASTER_DNS = null;
        this.NORMAL_DNS = null;
        this.SOA_MASTER_DNS_IP = 0;
        Entry nextEntry = this.header.next;
        while (nextEntry != this.header) {
            Entry targetEntry = nextEntry;
            nextEntry = targetEntry.next;
            targetEntry.next.previous = targetEntry.previous;
            targetEntry.previous.next = targetEntry.next;
            targetEntry.clear();
        }
    }

    public void destroy() {
        this.clear();
        this.header = null;
    }

    public void printResult() {
        log.debug("min:" + String.valueOf(this.minref));
        log.debug("serial:" + String.valueOf(this.serial));
        Entry nextEntry = this.header.next;
        while (nextEntry != this.header) {
            log.debug((nextEntry.preference < 0 ? "ETC:" : "MailExchanger:") + nextEntry.domain + "/" + String.valueOf(nextEntry.preference));
            for (int iIPs = nextEntry.listArecord.size; iIPs > 0; --iIPs) {
                int iIP = nextEntry.listArecord.get(iIPs - 1);
                byte[] byteIP = LookupUtil.getIntToInetByteArray(iIP);
                log.debug("Address:" + (byteIP[0] & 0xFF) + "." + (byteIP[1] & 0xFF) + "." + (byteIP[2] & 0xFF) + "." + (byteIP[3] & 0xFF));
            }
            nextEntry = nextEntry.next;
        }
    }

    public void calculateMxCounts() throws NoMXRecordFoundException {
        this.minMxCount = 0;
        this.etcMxCount = 0;
        Entry nextEntry = this.header.next;
        this.minref = Integer.MAX_VALUE;
        while (nextEntry != this.header) {
            if (nextEntry.listArecord.size == 0) {
                nextEntry.previous.next = nextEntry.next;
                nextEntry.next.previous = nextEntry.previous;
                nextEntry.destroy();
                this.minref = Integer.MAX_VALUE;
                nextEntry = this.header.next;
                continue;
            }
            if (nextEntry.preference < this.minref) {
                this.minref = nextEntry.preference;
            }
            nextEntry = nextEntry.next;
        }
        nextEntry = this.header.next;
        while (nextEntry != this.header) {
            if (nextEntry.preference == this.minref) {
                this.minMxCount += nextEntry.listArecord.size;
            } else if (nextEntry.preference >= 0) {
                this.etcMxCount += nextEntry.listArecord.size;
            }
            nextEntry = nextEntry.next;
        }
        if (this.minMxCount == 0) {
            throw new NoMXRecordFoundException("NO MX Record or MX Record has no A Record");
        }
    }

    public int getMXDomainCount() {
        int returnValue = 0;
        Entry nextEntry = this.header.next;
        while (nextEntry != this.header) {
            if (nextEntry.preference >= 0) {
                ++returnValue;
            }
            nextEntry = nextEntry.next;
        }
        return returnValue;
    }

    public void setResult(MXSearchResult result) {
        int idx = 0;
        Entry nextEntry = this.header.next;
        result.INDEX_OF_FIRST_REFERENCE_SEQUENCE = this.minMxCount;
        result.SEARCH_TIME = System.currentTimeMillis();
        result.setError(0, null);
        while (nextEntry != this.header) {
            if (log.isDebugEnabled()) {
                log.debug((nextEntry.preference < 0 ? "ETC:" : "MailExchanger:") + nextEntry.domain + "/" + String.valueOf(nextEntry.preference));
            }
            if (nextEntry.preference >= 0) {
                for (int iIPs = nextEntry.listArecord.size; iIPs > 0; --iIPs) {
                    int iIP = nextEntry.listArecord.get(iIPs - 1);
                    if (log.isDebugEnabled()) {
                        byte[] byteIP = LookupUtil.getIntToInetByteArray(iIP);
                        log.debug("Address:" + (byteIP[0] & 0xFF) + "." + (byteIP[1] & 0xFF) + "." + (byteIP[2] & 0xFF) + "." + (byteIP[3] & 0xFF));
                    }
                    result.set(idx, nextEntry.domain, iIP);
                    ++idx;
                }
            }
            nextEntry = nextEntry.next;
        }
    }

    public InetAddress getSOAInetAddress() throws UnknownHostException {
        if (this.SOA_MASTER_DNS_IP == 0 && this.SOA_MASTER_DNS != null) {
            if (log.isDebugEnabled()) {
                MXResultSorter.log("no soa contain ip:" + this.SOA_MASTER_DNS);
            }
            InetAddress inet = InetAddress.getByName(this.SOA_MASTER_DNS);
            inet = this.exactSOA ? InetAddress.getByName(this.SOA_MASTER_DNS) : InetAddress.getByName(this.NORMAL_DNS);
            String hostip = inet.getHostAddress();
            int[] address = NetAddress.getIntArray(hostip);
            this.SOA_MASTER_DNS_IP = LookupUtil.getIntIPToInetInt(address[0], address[1], address[2], address[3]);
        }
        if (this.SOA_MASTER_DNS_IP == 0) {
            return null;
        }
        byte[] address = LookupUtil.getIntToInetByteArray(this.SOA_MASTER_DNS_IP);
        return InetAddress.getByAddress(address);
    }

    static final void log(String log) {
        LookupCacheManager.log(log);
    }

    static final void log(Throwable log) {
        LookupCacheManager.log(log);
    }

    static class AddressArrayList {
        private int[] elementData;
        private int size;

        AddressArrayList(int initialCapacity) {
            this.elementData = new int[initialCapacity];
        }

        AddressArrayList() {
            this(10);
        }

        void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elementData.length;
            if (minCapacity > oldCapacity) {
                int[] oldData = this.elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new int[newCapacity];
                System.arraycopy(oldData, 0, this.elementData, 0, this.size);
            }
        }

        int size() {
            return this.size;
        }

        int get(int index) {
            return this.elementData[index];
        }

        void add(int o) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != o) continue;
                return;
            }
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = o;
        }

        void clear() {
            this.size = 0;
        }

        void destroy() {
            this.size = -1;
            this.elementData = null;
        }
    }

    protected static class Entry {
        protected String domain;
        protected int preference = -1;
        protected Entry next;
        protected Entry previous;
        protected AddressArrayList listArecord = null;

        Entry(String d, int pref, Entry n, Entry p) {
            this.domain = d;
            this.next = n;
            this.previous = p;
            this.preference = pref;
            this.listArecord = new AddressArrayList();
        }

        protected void putARecord(int aRecord) {
            this.listArecord.add(aRecord);
        }

        void setPreference(int pref) {
            this.preference = pref;
        }

        void clear() {
            this.domain = null;
            this.next = null;
            this.previous = null;
            this.listArecord.clear();
        }

        void destroy() {
            this.domain = null;
            this.next = null;
            this.previous = null;
            this.listArecord.destroy();
        }
    }
}

