/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.mail.mx.DiskCacheController;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXSearchResult;
import pluto.net.NetAddress;
import pluto.schedule.ScheduledMonitor;
import pluto.util.eMsStringTokenizer;

public class LookupCacheManager
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(LookupCacheManager.class);
    static LookupCacheManager instance = null;
    private static LogChannel LOG_CHANNEL = null;
    public static int SEARCH_ERROR_DIRECT_SEARCH_COUNT = 3;
    protected static long SEARCH_ERROR_DOMAIN_TTL = 600000L;
    protected static long SEARCH_SUCCESS_DOMAIN_TTL = 21600000L;
    protected static boolean LOOKUP_DAY_FLAG = false;
    protected static int LOOKUP_DAY_HH24 = 1;
    private static boolean RELAY_SERVER_PRESENT = false;
    private static MXSearchResult RELAY_MX_SEARCH_RESULT = null;
    public static InetAddress[] DNS_RESOLVER_LIST = null;
    public static String RELAY_HOST_AFTER_DNS = null;
    public static int RELAY_HOST_AFTER_DNS_IP = 0;
    protected static final String RELAY_TEST_DNS = "test.amail.co.kr";
    public static Properties RELAY_DNS_HOSTS = new Properties();
    protected static String HOSTS_PATH = "/etc/hosts";
    public static boolean RELAY_DNS_HOSTS_ACTIVE = false;
    static Map<String, MXSearchResult> HASH_MX_SEARCH_RESULT = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void init(Object tmp) throws Exception {
        String tmplist;
        int[] ips;
        Properties prop;
        String sChannelID;
        if (instance == null) {
            instance = new LookupCacheManager();
            instance.start();
        }
        if ((sChannelID = (prop = (Properties)tmp).getProperty("logger")) != null) {
            LOG_CHANNEL = LogChannelContainer.get(sChannelID);
        }
        String RELAY_SERVER_IP = prop.getProperty("relay.server");
        if (eMsLocale.MGS_FLAG) {
            RELAY_SERVER_IP = eMsLocale.MGS_SERVER;
        }
        if ((RELAY_HOST_AFTER_DNS = prop.getProperty("dns.relay.server", null)) != null) {
            ips = NetAddress.getIntArray(RELAY_HOST_AFTER_DNS);
            RELAY_HOST_AFTER_DNS_IP = LookupUtil.getIntIPToInetInt(ips[0], ips[1], ips[2], ips[3]);
            RELAY_HOST_AFTER_DNS = RELAY_TEST_DNS;
        }
        boolean bl = RELAY_SERVER_PRESENT = RELAY_SERVER_IP != null;
        if (RELAY_SERVER_PRESENT) {
            ips = NetAddress.getIntArray(RELAY_SERVER_IP);
            int iIP = LookupUtil.getIntIPToInetInt(ips[0], ips[1], ips[2], ips[3]);
            RELAY_MX_SEARCH_RESULT = new MXSearchResult(RELAY_SERVER_IP);
            RELAY_MX_SEARCH_RESULT.init(2);
            RELAY_MX_SEARCH_RESULT.set(0, RELAY_SERVER_IP, iIP);
            RELAY_MX_SEARCH_RESULT.set(1, RELAY_SERVER_IP, iIP);
        }
        if ((tmplist = prop.getProperty("server.list")) == null) {
            throw new RuntimeException("server.list parameter is not set");
        }
        eMsStringTokenizer TOKEN = new eMsStringTokenizer(tmplist, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (TOKEN.hasMoreTokens()) {
            list.add(TOKEN.nextToken());
        }
        DNS_RESOLVER_LIST = new InetAddress[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            LookupCacheManager.DNS_RESOLVER_LIST[i] = NetAddress.getInetAddress(((String)list.get(i)).toString());
        }
        String tmpLookupSuccessTTL = prop.getProperty("lookup.success.ttl");
        try {
            SEARCH_SUCCESS_DOMAIN_TTL = Long.parseLong(tmpLookupSuccessTTL);
        }
        catch (Exception e) {
            log.error("LookupContainer", (Object)"default value setting error", (Object)e);
        }
        String tmpLookupFailTTL = prop.getProperty("lookup.error.ttl");
        try {
            SEARCH_ERROR_DOMAIN_TTL = Long.parseLong(tmpLookupFailTTL);
        }
        catch (Exception e) {
            log.error("LookupContainer", (Object)"default value setting error", (Object)e);
        }
        LOOKUP_DAY_FLAG = "Y".equals(prop.getProperty("lookup.day.flag", "N"));
        LOOKUP_DAY_HH24 = Integer.parseInt(prop.getProperty("lookup.day.hh24", "01"));
        HASH_MX_SEARCH_RESULT = new ConcurrentHashMap<String, MXSearchResult>();
        HOSTS_PATH = prop.getProperty("hosts.path", null);
        if (HOSTS_PATH != null) {
            FileReader oFileReader = null;
            BufferedReader oReader = null;
            String sLine = "";
            String sIP = "";
            try {
                oFileReader = new FileReader(HOSTS_PATH);
                oReader = new BufferedReader(oFileReader);
                while ((sLine = oReader.readLine()) != null) {
                    if (sLine.indexOf("#") > -1) {
                        sLine = sLine.substring(0, sLine.indexOf("#"));
                    }
                    sLine = sLine.trim();
                    sLine = sLine.replace('\t', ' ');
                    int idx1 = -1;
                    int idx2 = -1;
                    boolean status = false;
                    String sTmp = "";
                    int nIP = -1;
                    if (sLine.length() <= 7) continue;
                    while ((idx1 = sLine.indexOf(" ", idx2 + 1)) != -1) {
                        sTmp = sLine.substring(idx2 + 1, idx1);
                        if (sTmp.length() < 2) {
                            idx2 = idx1;
                            continue;
                        }
                        if (!status) {
                            sIP = sTmp;
                            int[] ips2 = NetAddress.getIntArray(sIP);
                            nIP = LookupUtil.getIntIPToInetInt(ips2[0], ips2[1], ips2[2], ips2[3]);
                            status = true;
                        } else {
                            RELAY_DNS_HOSTS.setProperty(sTmp, String.valueOf(nIP));
                        }
                        idx2 = idx1;
                    }
                    if (idx2 >= sLine.length()) continue;
                    sTmp = sLine.substring(idx2 + 1);
                    RELAY_DNS_HOSTS.setProperty(sTmp, String.valueOf(nIP));
                }
                RELAY_DNS_HOSTS_ACTIVE = true;
            }
            catch (Exception e) {
                log.error(" Hosts File Is Not Found ", (Throwable)e);
            }
            finally {
                if (oReader != null) {
                    try {
                        oReader.close();
                    }
                    catch (Exception e) {}
                }
                if (oFileReader != null) {
                    try {
                        oFileReader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        DiskCacheController.init(tmp);
    }

    public int getDnsResolverSize() {
        return DNS_RESOLVER_LIST.length;
    }

    public static synchronized void unload() {
        instance.close();
    }

    public static synchronized void setLogChannel(LogChannel channel) {
        LOG_CHANNEL = channel;
    }

    public static synchronized void log(String logStr) {
        if (LOG_CHANNEL == null) {
            log.info("log channel is null" + logStr);
        } else {
            try {
                LOG_CHANNEL.write(logStr);
            }
            catch (Exception e) {
                log.error("log write error", (Throwable)e);
            }
        }
    }

    public static synchronized void log(Throwable thr) {
        if (LOG_CHANNEL == null) {
            log.info("log channel is null", thr);
        } else {
            try {
                LOG_CHANNEL.write(thr);
            }
            catch (Exception e) {
                log.error("LookupContainer", (Object)"log write error", (Object)e);
            }
        }
    }

    public static final synchronized MXSearchResult getMXrelayInfo() {
        if (RELAY_SERVER_PRESENT) {
            return RELAY_MX_SEARCH_RESULT;
        }
        return null;
    }

    public static final synchronized MXSearchResult getMXSearchResult(String domain) {
        MXSearchResult result = HASH_MX_SEARCH_RESULT.get(domain);
        if (result == null) {
            result = new MXSearchResult(domain);
            HASH_MX_SEARCH_RESULT.put(domain, result);
        }
        return result;
    }

    public static Throwable isInvalidDomain(String domain) {
        if (RELAY_SERVER_PRESENT) {
            return null;
        }
        MXSearchResult dummy = HASH_MX_SEARCH_RESULT.get(domain);
        if (dummy == null) {
            return null;
        }
        MXSearchResult tmpList = dummy;
        if (tmpList.isError() && tmpList.isValidTime() && tmpList.getCountErrorRaise() >= SEARCH_ERROR_DIRECT_SEARCH_COUNT) {
            return tmpList.getError();
        }
        return null;
    }

    LookupCacheManager() {
        super(60000L);
    }

    public void touch(String domain) {
    }

    @Override
    protected void check() throws Exception {
    }
}

