/*
 * Decompiled with CFR 0.152.
 */
package pluto.lang;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.Name;
import pluto.lang.UniqueKey;
import pluto.util.FIFOBuffer;

public class eMsStringBuffer
extends Name {
    private static final Logger log = LoggerFactory.getLogger(eMsStringBuffer.class);
    private static final int MAX_CONTAIN_SIZE = 10;
    private static FIFOBuffer INNER_CONTAINER = null;
    private char[] value;
    private int count;
    private String callerName = null;
    private boolean calledFalg = false;

    public static eMsStringBuffer getInstance() {
        Object tmpValue = INNER_CONTAINER.pop();
        eMsStringBuffer returnValue = tmpValue == null ? new eMsStringBuffer() : (eMsStringBuffer)tmpValue;
        returnValue.setCallerName(Thread.currentThread().getName());
        return returnValue;
    }

    public static void recycleInstance(eMsStringBuffer tmp) {
        Exception e;
        if (tmp == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            String tName = tmp.getCallerName();
            if (!Thread.currentThread().getName().equals(tName)) {
                Exception e2 = new Exception("defferent .. worker:" + Thread.currentThread().getName() + "## getter" + tmp.getCallerName() + " => " + tmp.getName());
                log.error("error", (Throwable)e2);
            }
        }
        if (tmp.length() > 4096) {
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + "=>" + tmp.getName() + " to large so no recycle");
            }
            tmp = null;
            return;
        }
        if (INNER_CONTAINER.contains(tmp)) {
            if (log.isDebugEnabled()) {
                e = new Exception(Thread.currentThread().getName() + "=>" + tmp.getName() + " is already in eMsStringBuffer FIFOBuffer");
                log.error("", (Throwable)e);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            e = new Exception(Thread.currentThread().getName() + "=>" + tmp.getName() + " is recycle");
            log.error("error", (Throwable)e);
        }
        tmp.reset();
        INNER_CONTAINER.push(tmp);
    }

    private eMsStringBuffer() {
        this(16);
    }

    private eMsStringBuffer(int length) {
        this.value = new char[length];
        this.setName("pluto.lang.eMsStringBuffer:".concat(UniqueKey.get()));
    }

    public eMsStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public void setCallerName(String name) {
        if (this.calledFalg) {
            throw new RuntimeException("ALREADY CALL FROM:" + this.getCallerName());
        }
        this.callerName = name;
        this.calledFalg = true;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public synchronized void setLength(int newLength) {
        if (newLength < 0 || newLength > this.count) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.count = newLength;
    }

    private synchronized void reset() {
        this.count = 0;
        this.calledFalg = false;
    }

    public synchronized void minusLength(int newLength) {
        if (newLength < 0 || newLength > this.count) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.count -= newLength;
    }

    public synchronized char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public synchronized void append(String str) {
        if (str == null) {
            return;
        }
        int len = str.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
    }

    public synchronized String reverseString() {
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this.toString();
    }

    public synchronized void append(String str, int beginIndex) {
        this.append(str, beginIndex, str.length());
    }

    public synchronized void append(String str, int beginIndex, int endIndex) {
        if (str == null) {
            return;
        }
        if (endIndex == beginIndex) {
            return;
        }
        int len = endIndex - beginIndex;
        if (len < 0) {
            throw new StringIndexOutOfBoundsException("Begin Index is Bigger than End Index " + len);
        }
        if (endIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("End Index is bigger than source length " + endIndex);
        }
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException("Begin Index is negative " + endIndex);
        }
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(beginIndex, len, this.value, this.count);
        this.count = newcount;
    }

    public synchronized void append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
    }

    public synchronized void append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
    }

    public synchronized void append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
    }

    public synchronized void appendReverse(String str) {
        for (int i = str.length(); i > 0; --i) {
            this.append(str.charAt(i - 1));
        }
    }

    public synchronized void delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
    }

    public synchronized void replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(this.toString() + ":" + String.valueOf(start) + ":" + String.valueOf(end) + ":" + str);
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
    }

    public synchronized void replace(String org, String str) {
        char[] orgArray = org.toCharArray();
        int org_length = orgArray.length;
        int idx_start = 0;
        int idx_end = 0;
        while ((idx_start = eMsStringBuffer.indexOf(this.value, 0, this.count, orgArray, 0, orgArray.length, idx_end)) >= 0) {
            this.replace(idx_start, idx_start + org_length, str);
            idx_end = idx_start + str.length();
        }
    }

    public static void main(String[] arg) throws Exception {
        eMsStringBuffer buffer = new eMsStringBuffer();
        buffer.append("112233344556677338338990033");
        buffer.replace("33", "\ud558\ud558\ud558");
        log.debug(buffer.toString());
    }

    public synchronized String substring(int start) {
        return this.substring(start, this.count);
    }

    public synchronized String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public synchronized void insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > str.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
    }

    public synchronized void insert(int offset, String str) {
        if (str == null) {
            return;
        }
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
    }

    public synchronized void insert(int offset, char[] str) {
        if (str == null) {
            return;
        }
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
    }

    public synchronized void insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
    }

    public synchronized String toString() {
        return new String(this.value, 0, this.count);
    }

    public int indexOfCaseIgnore(String org) {
        return this.indexOfCaseIgnore(org, 0);
    }

    public int indexOfCaseIgnore(String org, int offset) {
        return eMsStringBuffer._indexOfCaseIgnore(this.value, 0, this.count, org.toCharArray(), 0, org.length(), offset);
    }

    public int indexOfLineEnd(int offset) {
        do {
            if (this.value[offset] != '\r' && this.value[offset] != '\n') continue;
            return offset;
        } while (++offset < this.count);
        return this.count;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    static int upperCase(char src) {
        char returnValue = src;
        if (returnValue >= 'a' && returnValue <= 'z') {
            return returnValue - 32;
        }
        return returnValue;
    }

    public static int _indexOfCaseIgnore(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int first = eMsStringBuffer.upperCase(target[targetOffset]);
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && eMsStringBuffer.upperCase(source[i]) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (eMsStringBuffer.upperCase(source[j++]) == eMsStringBuffer.upperCase(target[k++])) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    public int findCharArray(char[] target, int i, int end_point) {
        end_point = end_point > this.count ? this.count : end_point;
        for (int idx = i; idx < end_point; ++idx) {
            for (int sidx = target.length; sidx > 0; --sidx) {
                if (this.value[idx] != target[sidx]) continue;
                return idx;
            }
        }
        return -1;
    }

    static {
        INNER_CONTAINER = new FIFOBuffer(10);
    }
}

