/*
 * Decompiled with CFR 0.152.
 */
package pluto.lang;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pluto.lang.NameInterface;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.util.StringConvertUtil;
import pluto.util.xml.XMLUtil;

public class Tracer {
    private static final Logger log = LoggerFactory.getLogger(Tracer.class);
    public static final short LOG_LEVEL_NETWORK = 5;
    public static final short LOG_LEVEL_DEBUG = 4;
    public static final short LOG_LEVEL_INFO = 3;
    public static final short LOG_LEVEL_NORMAL = 2;
    public static final short LOG_LEVEL_ERROR = 1;
    private static LogChannel LOG_CHANNEL_INSTANCE = null;
    private static short LOG_LEVEL = (short)2;
    private static StringBuffer __INNER_BUFFER__ = new StringBuffer(1024);

    protected Tracer() {
    }

    public static synchronized void init(Object prop) throws Exception {
        Element ELEMENT = (Element)prop;
        String level = XMLUtil.getSubElementAttribute(ELEMENT, "level", "value");
        String LOGCHANNEL_ID = XMLUtil.getSubElementAttribute(ELEMENT, "LOGGER", "ID");
        if (LOGCHANNEL_ID == null) {
            return;
        }
        LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
    }

    public static void setLogChannel(LogChannel a) {
        LOG_CHANNEL_INSTANCE = a;
    }

    public static synchronized void network(Throwable src) {
        Tracer.put((short)4, src);
    }

    public static synchronized void network(String name, Throwable src) {
        Tracer.put((short)4, name, src);
    }

    public static synchronized void network(String name, String src) {
        Tracer.put((short)4, name, src);
    }

    public static synchronized void network(String name, String src, Throwable t) {
        Tracer.put((short)4, name, src, t);
    }

    public static synchronized void network(String name) {
        Tracer.put((short)4, name);
    }

    public static synchronized void detail(Throwable src) {
        Tracer.put((short)4, src);
    }

    public static synchronized void detail(String name, Throwable src) {
        Tracer.put((short)4, name, src);
    }

    public static synchronized void detail(String name, String src) {
        Tracer.put((short)4, name, src);
    }

    public static synchronized void detail(String name, String src, Throwable t) {
        Tracer.put((short)4, name, src, t);
    }

    public static synchronized void detail(String name) {
        Tracer.put((short)4, name);
    }

    public static synchronized void info(Throwable src) {
        Tracer.put((short)3, src);
    }

    public static synchronized void info(String name, Throwable src) {
        Tracer.put((short)3, name, src);
    }

    public static synchronized void info(String name, String src) {
        Tracer.put((short)3, name, src);
    }

    public static synchronized void info(Object name, String src, Object t) {
        Tracer.put((short)3, name, src, t);
    }

    public static synchronized void info(String name) {
        Tracer.put((short)3, name);
    }

    public static synchronized void normal(Throwable src) {
        Tracer.put((short)3, src);
    }

    public static synchronized void normal(String name, Throwable src) {
        Tracer.put((short)3, name, src);
    }

    public static synchronized void normal(String name, String src) {
        Tracer.put((short)3, name, src);
    }

    public static synchronized void normal(Object name, String src, Object t) {
        Tracer.put((short)3, name, src, t);
    }

    public static synchronized void normal(String name) {
        Tracer.put((short)3, name);
    }

    public static synchronized void error(Throwable src) {
        Tracer.put((short)1, src);
    }

    public static synchronized void error(String name, Throwable src) {
        Tracer.put((short)1, name, src);
    }

    public static synchronized void error(String name, String src) {
        Tracer.put((short)1, name, src);
    }

    public static synchronized void error(Object name, String src, Object t) {
        Tracer.put((short)1, name, src, t);
    }

    public static synchronized void error(String name) {
        Tracer.put((short)1, name);
    }

    public static synchronized void debug(Throwable src) {
        if (log.isDebugEnabled()) {
            Tracer.put((short)4, src);
        }
    }

    public static synchronized void debug(String name, Throwable src) {
        if (log.isDebugEnabled()) {
            Tracer.put((short)4, name, src);
        }
    }

    public static synchronized void debug(String name, String src) {
        if (log.isDebugEnabled()) {
            Tracer.put((short)4, name, src);
        }
    }

    public static synchronized void debug(Object name, String src, Object t) {
        if (log.isDebugEnabled()) {
            Tracer.put((short)4, name, src, t);
        }
    }

    public static synchronized void debug(String name) {
        if (log.isDebugEnabled()) {
            Tracer.put((short)4, name);
        }
    }

    protected static synchronized void put(short logLevel, Throwable src) {
        Tracer.put(logLevel, null, "ECHO Stack", src);
    }

    protected static void put(short logLevel, String name, Throwable src) {
        Tracer.put(logLevel, null, name, src);
    }

    protected static void put(short logLevel, String name, String src) {
        Tracer.put(logLevel, name, src, null);
    }

    protected static synchronized void put(short logLevel, Object name, String src, Object t) {
        __INNER_BUFFER__.setLength(0);
        if (name != null) {
            if (name instanceof NameInterface) {
                __INNER_BUFFER__.append(((NameInterface)name).getName());
            } else {
                __INNER_BUFFER__.append(name.toString());
            }
            __INNER_BUFFER__.append(" => ");
        }
        __INNER_BUFFER__.append(src);
        if (t != null) {
            __INNER_BUFFER__.append(" : ");
            if (t instanceof Throwable) {
                __INNER_BUFFER__.append(StringConvertUtil.exToString((Throwable)t));
            } else {
                __INNER_BUFFER__.append(t.toString());
            }
        }
        Tracer.put(logLevel, __INNER_BUFFER__.toString());
    }

    protected static synchronized void put(short logLevel, String src) {
        switch (logLevel) {
            case 4: {
                log.debug(src);
                break;
            }
            case 1: {
                log.error(src);
            }
            default: {
                log.info(src);
            }
        }
    }
}

