/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.ByteArrayContainer;

public class eMsBufferedOutputStream
extends FilterOutputStream {
    private static final Logger log = LoggerFactory.getLogger(eMsBufferedOutputStream.class);
    protected byte[] buf = ByteArrayContainer.getInstance();
    protected int count;

    public eMsBufferedOutputStream(OutputStream o) {
        super(o);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        ByteArrayContainer.recycleInstance(this.buf);
    }

    protected void writeNumericType(int val) throws IOException {
        this.write(val >>> 8);
        this.write(val >>> 0);
    }
}

