/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import pluto.io.FileElement;

public class HttpsFileElement
extends FileElement {
    private static final boolean INNER_DEBUG = false;
    HttpsURLConnection m_client = null;

    protected HttpsFileElement() throws Exception {
    }

    @Override
    public InputStream getStream() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String paramString, SSLSession paramSSLSession) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        URL myURL = new URL(HttpsFileElement.converValidUrl(this.FileUrl.trim()));
        int __RESPONSE_CODE__ = 0;
        try {
            this.m_client = (HttpsURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = this.m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception _ex) {
                // empty catch block
            }
            this.m_client = (HttpsURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = this.m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTPS Status-Code 403: Forbidden.=>".concat(this.FileUrl));
            }
            case 500: {
                throw new IOException("HTTPS Status-Code 500: Internal Server Error.=>".concat(this.FileUrl));
            }
            case 406: {
                throw new IOException("HTTPS Status-Code 406: Not Acceptable.=>".concat(this.FileUrl));
            }
            case 404: {
                throw new IOException("HTTPS Status-Code 404: Not Found.=>".concat(this.FileUrl));
            }
            case 503: {
                throw new IOException("HTTPS Status-Code 503: Service Unavailable.=>".concat(this.FileUrl));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(this.m_client.getResponseMessage().concat("=>").concat(this.FileUrl));
            }
        }
        return this.m_client.getInputStream();
    }

    @Override
    public void close() {
        if (this.m_client != null) {
            try {
                this.m_client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String converValidUrl(String url) {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(256);
            buffer.append(url.replaceAll("\\ ", "%20"));
            String string = buffer.toString();
            return string;
        }
        catch (Throwable t) {
            t.printStackTrace();
            String string = url;
            return string;
        }
        finally {
            buffer = null;
        }
    }
}

