/*
 * Decompiled with CFR 0.152.
 */
package pluto.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatementInterface;
import pluto.util.StringConvertUtil;

public class eMsStatement
implements eMsStatementInterface {
    private static final Logger log = LoggerFactory.getLogger(eMsStatement.class);
    private Statement stmt = null;
    private eMsConnection EMS_CONNECTION = null;

    public static final void releaseStmt(eMsStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    protected eMsStatement() {
    }

    @Override
    public void connectTo(eMsConnection conn) throws SQLException {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.EMS_CONNECTION = conn;
        this.stmt = this.EMS_CONNECTION.createInnerStatement();
    }

    @Override
    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String query) {
        if (this.stmt == null) {
            return false;
        }
        ResultSet rs = null;
        try {
            rs = this.stmt.executeQuery(query);
            rs.next();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return true;
    }

    public int executeUpdate(String query, Object info, String start, String end) throws Exception {
        return this.executeUpdate(query, info, start, end, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String query, Object info, String start, String end, int sec) throws Exception {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(512);
            StringConvertUtil.ConvertString(buffer, query, info, start, end, true, false);
            int n = this.executeUpdate(buffer.toString(), sec);
            return n;
        }
        finally {
            buffer = null;
        }
    }

    public int executeUpdate(String query) throws SQLException {
        return this.executeUpdate(query, 600);
    }

    public int executeUpdate(String query, int sec) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(sec);
            int n = this.stmt.executeUpdate(this.EMS_CONNECTION.encode(query));
            return n;
        }
        catch (SQLException e) {
            log.error("EXEC ERROR", (Object)query);
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public eMsResultSet executeQuery(String query, Object info, String start, String end) throws Exception {
        return this.executeQuery(query, info, start, end, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public eMsResultSet executeQuery(String query, Object info, String start, String end, int sec) throws Exception {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            StringConvertUtil.ConvertString(buffer, query, info, start, end, true, false);
            eMsResultSet eMsResultSet2 = this.executeQuery(buffer.toString(), sec);
            return eMsResultSet2;
        }
        finally {
            buffer = null;
        }
    }

    public eMsResultSet executeQuery(String query) throws SQLException {
        return this.executeQuery(query, 600);
    }

    public eMsResultSet executeQuery(String query, String dbType) throws SQLException {
        return this.executeQuery(query, dbType, 600);
    }

    public eMsResultSet executeQuery(String query, String dbType, int sec) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(sec);
            eMsResultSet eMsResultSet2 = new eMsResultSet(this.EMS_CONNECTION, this.stmt.executeQuery(this.EMS_CONNECTION.encode(query)), dbType);
            return eMsResultSet2;
        }
        catch (SQLException e) {
            log.error("EXEC ERROR", (Object)query);
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public eMsResultSet executeQuery(String query, int sec) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(sec);
            eMsResultSet eMsResultSet2 = new eMsResultSet(this.EMS_CONNECTION, this.stmt.executeQuery(this.EMS_CONNECTION.encode(query)));
            return eMsResultSet2;
        }
        catch (SQLException e) {
            log.error("EXEC ERROR", (Object)query);
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public boolean checkResultTargetQuery(String query, int sec) throws SQLException {
        ResultSet tmprs = null;
        try {
            this.EMS_CONNECTION.setIdleLimitTime(sec);
            if (log.isDebugEnabled()) {
                log.debug("rs check exec=>" + query.substring(0, query.length() > 30 ? 30 : query.length()));
            }
            if ((tmprs = this.stmt.executeQuery(this.EMS_CONNECTION.encode(query))).next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.error("SQL EXEC ERROR", (Object)query);
            throw e;
        }
        finally {
            if (tmprs != null) {
                try {
                    tmprs.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            this.EMS_CONNECTION.releaseIdleLimitTime();
            if (log.isDebugEnabled()) {
                log.debug("exec end");
            }
        }
    }

    public boolean execute(String query, Object info, String start, String end) throws Exception {
        return this.execute(query, info, start, end, 600);
    }

    public boolean execute(String query, Object info, String start, String end, int sec) throws Exception {
        return this.execute(StringConvertUtil.ConvertString(query, info, start, end, true, false), sec);
    }

    public boolean execute(String query) throws SQLException {
        return this.execute(query, 600);
    }

    public boolean execute(String query, int sec) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(sec);
            boolean bl = this.stmt.execute(this.EMS_CONNECTION.encode(query));
            return bl;
        }
        catch (SQLException e) {
            log.error("EXEC ERROR", (Object)query);
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public eMsResultSet getResultSet() throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            eMsResultSet eMsResultSet2 = new eMsResultSet(this.EMS_CONNECTION, this.stmt.getResultSet());
            return eMsResultSet2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            int n = this.stmt.getUpdateCount();
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }
}

