/*
 * Decompiled with CFR 0.152.
 */
package pluto.config;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;

public class SqlManager {
    private static final Logger log = LoggerFactory.getLogger(SqlManager.class);
    public static final char TAB = '\t';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char BLANK = ' ';
    public static String name = "SqlManager";
    public static String SERVER_ID = null;
    private static Hashtable MAP_OF_QUERY = new Hashtable();

    public static String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        String filename = tmp.getProperty("target.file");
        if (SERVER_ID == null) {
            SERVER_ID = tmp.getProperty("ems.server.id", "01");
        }
        log.info(SqlManager.getName() + " is init from " + filename);
        Document sqlDoc = DOMParser.getDocumentFromUrl(filename);
        Element __ROOT = (Element)sqlDoc.getElementsByTagName("QUERY").item(0);
        NodeList __PROGRAM_LIST = __ROOT.getElementsByTagName("PROGRAM");
        int __PROGRAM_LIST_LENGTH = __PROGRAM_LIST.getLength();
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            for (int __PROGRAM_INDEX = 0; __PROGRAM_INDEX < __PROGRAM_LIST_LENGTH; ++__PROGRAM_INDEX) {
                Element __PROGRAM_ELEMENT = (Element)__PROGRAM_LIST.item(__PROGRAM_INDEX);
                String __PROGRAM_NAME = __PROGRAM_ELEMENT.getAttribute("NAME");
                NodeList __QUERY_LIST = __PROGRAM_ELEMENT.getElementsByTagName("sql");
                int __QUERY_LIST_LENGTH = __QUERY_LIST.getLength();
                for (int __SQL_INDEX = 0; __SQL_INDEX < __QUERY_LIST_LENGTH; ++__SQL_INDEX) {
                    Element __SQL_ELEMENT = (Element)__QUERY_LIST.item(__SQL_INDEX);
                    String __SQL_ID = __SQL_ELEMENT.getAttribute("ID");
                    List __TARGET_QUERY = XMLUtil.getMultiCDATA_SECTION(__SQL_ELEMENT);
                    PlutoLinkedList __INSERT_LIST = new PlutoLinkedList();
                    Iterator iter = __TARGET_QUERY.iterator();
                    while (iter.hasNext()) {
                        String value = iter.next().toString();
                        if (value.trim().length() < 1) {
                            iter.remove();
                            continue;
                        }
                        buffer.setLength(0);
                        StringConvertUtil.ConvertString(buffer, SqlManager.ConvertEscapeCharactor(value.trim()), "##SERVER_ID##", SERVER_ID);
                        __INSERT_LIST.add(buffer.toString());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[" + __PROGRAM_NAME.concat("_").concat(__SQL_ID) + "] SET");
                    }
                    MAP_OF_QUERY.put(__PROGRAM_NAME.concat("_").concat(__SQL_ID), __INSERT_LIST);
                }
            }
        }
        finally {
            buffer = null;
        }
    }

    public static synchronized String getQuery(String __PROGRAM_NAME, String __SQL_ID) {
        Object returnValue = MAP_OF_QUERY.get(__PROGRAM_NAME.concat("_").concat(__SQL_ID));
        if (returnValue == null) {
            log.error(__PROGRAM_NAME + "|" + __SQL_ID + "NOT IN SQL XML");
            return null;
        }
        List __TARGET_LIST = (List)returnValue;
        if (__TARGET_LIST.size() < 1) {
            return "";
        }
        return __TARGET_LIST.iterator().next().toString();
    }

    public static synchronized List getMultiQuery(String __PROGRAM_NAME, String __SQL_ID) {
        Object returnValue;
        if (log.isDebugEnabled()) {
            log.debug("search:" + __PROGRAM_NAME.concat("_").concat(__SQL_ID));
        }
        if ((returnValue = MAP_OF_QUERY.get(__PROGRAM_NAME.concat("_").concat(__SQL_ID))) == null) {
            log.error(__PROGRAM_NAME + "|" + __SQL_ID, (Object)"NOT IN SQL XML");
            return null;
        }
        return (List)returnValue;
    }

    public static String ConvertEscapeCharactor(String src) throws Exception {
        if (src == null) {
            return "";
        }
        return src.replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
    }
}

