/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import pluto.log.LogChannel;
import pluto.util.Cal;
import pluto.util.xml.XMLUtil;

public class TimeStampLogChannel
extends LogChannel {
    private static final Logger log = LoggerFactory.getLogger(TimeStampLogChannel.class);
    protected Date DATE_INSTANCE = new Date();
    protected String BASE_DIRECTORY = null;
    protected String FILE_NAME_PREFIX = null;
    protected String FILE_NAME_SURFIX = null;
    protected String TIME_STAMP = null;
    protected SimpleDateFormat TIME_STAMP_INSTANCE = null;
    protected String CURRENT_DATE = "^^";
    protected eMsFileWriter WRITER_INSTANCE = null;
    protected String CURRENT_FILENAME = "^^";
    protected boolean CREATE_SUB_DIR = false;
    protected boolean SYS_ECHO_FLAG = false;
    protected boolean THREAD_ECHO_FLAG = false;
    protected boolean TIME_ECHO_FLAG = false;
    protected long NEXT_CHECK_TIME = System.currentTimeMillis() - 86400000L;

    public TimeStampLogChannel() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    protected void setRule(Object info) throws Exception {
        Element LOGGER_ELEMENT = (Element)info;
        this.SYS_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SYS-ECHO", "value").equals("true");
        this.THREAD_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "THREAD-ECHO", "value").equals("true");
        this.TIME_ECHO_FLAG = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIME-ECHO", "value").equals("true");
        this.BASE_DIRECTORY = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "value");
        this.CREATE_SUB_DIR = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "subdir").equals("true");
        this.FILE_NAME_PREFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "PREFIX", "value");
        this.FILE_NAME_SURFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SURFIX", "value");
        this.TIME_STAMP = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIMESTAMP", "value");
        this.TIME_STAMP_INSTANCE = new SimpleDateFormat(this.TIME_STAMP);
    }

    @Override
    public synchronized void write(String obj) throws Exception {
        try {
            this.setTargetFile();
            if (this.TIME_ECHO_FLAG) {
                String time = Cal.getDate();
                this.WRITER_INSTANCE.write(time);
                this.WRITER_INSTANCE.write("\t");
            }
            if (this.THREAD_ECHO_FLAG) {
                this.WRITER_INSTANCE.write("[");
                this.WRITER_INSTANCE.write(Thread.currentThread().getName());
                this.WRITER_INSTANCE.write("]");
            }
            this.WRITER_INSTANCE.println(obj);
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
    }

    protected void setTargetFile() throws Exception {
        if (this.NEXT_CHECK_TIME > System.currentTimeMillis()) {
            return;
        }
        this.NEXT_CHECK_TIME = System.currentTimeMillis() + 60000L;
        this.DATE_INSTANCE.setTime(System.currentTimeMillis());
        if (this.CURRENT_DATE.equals(this.TIME_STAMP_INSTANCE.format(this.DATE_INSTANCE))) {
            return;
        }
        if (this.WRITER_INSTANCE != null) {
            try {
                this.WRITER_INSTANCE.close();
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        this.CURRENT_DATE = this.TIME_STAMP_INSTANCE.format(this.DATE_INSTANCE);
        this.CURRENT_FILENAME = this.CREATE_SUB_DIR ? FileElement.CheckSubDirectory(this.BASE_DIRECTORY, Cal.getDayDate()) + "/" + this.FILE_NAME_PREFIX + this.CURRENT_DATE + this.FILE_NAME_SURFIX : this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + this.CURRENT_DATE + this.FILE_NAME_SURFIX;
        this.WRITER_INSTANCE = new eMsFileWriter(this.CURRENT_FILENAME, true);
    }
}

