/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.log;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pluto.io.eMsSizeIndexedOutputStream;
import pluto.log.LogChannel;
import pluto.util.Cal;
import pluto.util.xml.XMLUtil;

public class StringIndexedLogChannel
extends LogChannel {
    private static final Logger log = LoggerFactory.getLogger(StringIndexedLogChannel.class);
    protected Date DATE_INSTANCE = new Date();
    protected String BASE_DIRECTORY = null;
    protected String FILE_NAME_PREFIX = null;
    protected String FILE_NAME_SURFIX = null;
    protected String TIME_STAMP = null;
    protected SimpleDateFormat TIME_STAMP_INSTANCE = null;
    protected String CURRENT_DATE = "^^";
    protected eMsSizeIndexedOutputStream WRITER_INSTANCE = null;
    protected long NEXT_CHECK_TIME = -1L;
    protected String CURRENT_LOG_FILE_NAME = null;
    protected String CURRENT_LOG_FILE_SWITCHED_NAME = null;
    protected Object __LOCK__ = new Object();

    public StringIndexedLogChannel() {
        this.NEXT_CHECK_TIME = System.currentTimeMillis() - 86400000L;
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    protected void setRule(Object info) throws Exception {
        Element LOGGER_ELEMENT = (Element)info;
        this.BASE_DIRECTORY = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "DIRECTORY", "value");
        this.FILE_NAME_PREFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "PREFIX", "value");
        this.FILE_NAME_SURFIX = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "SURFIX", "value");
        this.TIME_STAMP = XMLUtil.getSubElementAttribute(LOGGER_ELEMENT, "TIMESTAMP", "value");
        this.TIME_STAMP_INSTANCE = new SimpleDateFormat(this.TIME_STAMP);
        final String prefix = this.FILE_NAME_PREFIX;
        final String surfix = this.FILE_NAME_SURFIX.concat(".ing");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(surfix);
            }
        };
        File base_dir = new File(this.BASE_DIRECTORY);
        String[] files = base_dir.list(filter);
        int idx = -1;
        for (int i = 0; i < files.length; ++i) {
            idx = files[i].indexOf(surfix);
            if (idx < 0) continue;
            File source = new File(this.BASE_DIRECTORY + "/" + files[i]);
            File target = new File(this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + Cal.getSerialDate() + this.FILE_NAME_SURFIX);
            source.renameTo(target);
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void write(String log) throws Exception {
        this.setTargetFile();
        this.WRITER_INSTANCE.writeString(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTargetFile() throws Exception {
        if (this.NEXT_CHECK_TIME > System.currentTimeMillis()) {
            return;
        }
        this.NEXT_CHECK_TIME = System.currentTimeMillis() + 60000L;
        this.DATE_INSTANCE.setTime(System.currentTimeMillis());
        if (this.CURRENT_DATE.equals(this.TIME_STAMP_INSTANCE.format(this.DATE_INSTANCE))) {
            return;
        }
        Object object = this.__LOCK__;
        synchronized (object) {
            if (this.WRITER_INSTANCE != null) {
                try {
                    this.WRITER_INSTANCE.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                File fileSource = new File(this.CURRENT_LOG_FILE_NAME);
                File fileTarget = new File(this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + Cal.getSerialDate() + this.FILE_NAME_SURFIX);
                fileSource.renameTo(fileTarget);
            }
            this.CURRENT_DATE = this.TIME_STAMP_INSTANCE.format(this.DATE_INSTANCE);
            this.CURRENT_LOG_FILE_SWITCHED_NAME = this.BASE_DIRECTORY + "/" + this.FILE_NAME_PREFIX + this.CURRENT_DATE;
            this.CURRENT_LOG_FILE_NAME = this.CURRENT_LOG_FILE_SWITCHED_NAME + this.FILE_NAME_SURFIX + ".ing";
            this.WRITER_INSTANCE = new eMsSizeIndexedOutputStream(this.CURRENT_LOG_FILE_NAME, false);
        }
    }
}

