/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectInfo;
import pluto.db.eMsConnection;

public class DBCPConnection
extends eMsConnection {
    private static final Logger log = LoggerFactory.getLogger(DBCPConnection.class);
    private static String EVICT_RUN_TIME = "5000";
    private static String EVICT_IDLE_TIME = "500";
    private static DataSource dataSource;
    private static GenericObjectPool connectionPool;
    private static int max_active;
    private static int max_idle;

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        String db_name = prop.getProperty("db.name", "ems");
        ConnectInfo connectInfo = (ConnectInfo)info.get(db_name);
        connectionPool = new GenericObjectPool(null);
        connectionPool.setMaxActive(Integer.parseInt(prop.getProperty("max.active", "25")));
        connectionPool.setMaxIdle(Integer.parseInt(prop.getProperty("max.idle", "15")));
        connectionPool.setMaxWait((long)Integer.parseInt(prop.getProperty("max.wait", "10")));
        if (prop.getProperty("test.on.return", "false").equals("true")) {
            connectionPool.setTestOnReturn(true);
        }
        if (prop.getProperty("test.while.idle", "false").equals("true")) {
            connectionPool.setTestWhileIdle(true);
        }
        if (prop.getProperty("test.on.borrow", "false").equals("true")) {
            connectionPool.setTestOnBorrow(true);
        }
        connectionPool.setMinEvictableIdleTimeMillis((long)Integer.parseInt(prop.getProperty("evict.idle.time", "-1")));
        connectionPool.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(prop.getProperty("evict.run.time", "150000")));
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectInfo.getDB_URL(), connectInfo.getDB_UID(), connectInfo.getDB_PASS());
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, connectInfo.getDB_INIT_QUERY(), false, true);
        poolableConnectionFactory.setConnectionInitSql(Arrays.asList(connectInfo.getDB_INIT_QUERY()));
        dataSource = new PoolingDataSource((ObjectPool)connectionPool);
    }

    public static void printDriverStats() throws Exception {
        if (max_active < connectionPool.getNumActive()) {
            log.info("NumActive :{}", (Object)connectionPool.getNumActive());
            max_active = connectionPool.getNumActive();
        }
        if (max_idle < connectionPool.getNumIdle()) {
            log.info("NumIdle :{}", (Object)connectionPool.getNumIdle());
            max_idle = connectionPool.getNumIdle();
        }
    }

    @Override
    public synchronized void ensureOpen() throws SQLException {
        if (this.conn != null) {
            this.recycle();
        }
        this.conn = dataSource.getConnection();
        try {
            DBCPConnection.printDriverStats();
        }
        catch (Exception e) {
            log.error("DRIVER STATE : " + e.getMessage());
        }
    }

    @Override
    public boolean expire() {
        return false;
    }

    static {
        max_active = 0;
        max_idle = 0;
    }
}

