/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;

public class TXTRecord
extends Record {
    private List strings;

    TXTRecord() {
    }

    @Override
    Record getObject() {
        return new TXTRecord();
    }

    public TXTRecord(Name name, int dclass, long ttl, List strings) {
        super(name, 16, dclass, ttl);
        if (strings == null) {
            throw new IllegalArgumentException("TXTRecord: strings must not be null");
        }
        this.strings = new ArrayList(strings.size());
        Iterator it = strings.iterator();
        try {
            while (it.hasNext()) {
                String s = (String)it.next();
                this.strings.add(TXTRecord.byteArrayFromString(s));
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public TXTRecord(Name name, int dclass, long ttl, String string) {
        this(name, dclass, ttl, Collections.nCopies(1, string));
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.strings = new ArrayList(2);
        while (in.remaining() > 0) {
            byte[] b = in.readCountedString();
            this.strings.add(b);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.strings = new ArrayList(2);
        while ((t = st.get()).isString()) {
            try {
                this.strings.add(TXTRecord.byteArrayFromString(t.value));
            }
            catch (TextParseException e) {
                throw st.exception(e.getMessage());
            }
        }
        st.unget();
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            byte[] array = (byte[])it.next();
            sb.append(TXTRecord.byteArrayToString(array, true));
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List getStrings() {
        ArrayList<String> list = new ArrayList<String>(this.strings.size());
        for (int i = 0; i < this.strings.size(); ++i) {
            list.add(TXTRecord.byteArrayToString((byte[])this.strings.get(i), false));
        }
        return list;
    }

    public List getStringsAsByteArrays() {
        return this.strings;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        for (byte[] b : this.strings) {
            out.writeCountedString(b);
        }
    }
}

