/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;

abstract class SingleNameBase
extends Record {
    protected Name singleName;

    protected SingleNameBase() {
    }

    protected SingleNameBase(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    protected SingleNameBase(Name name, int type, int dclass, long ttl, Name singleName, String description) {
        super(name, type, dclass, ttl);
        this.singleName = SingleNameBase.checkName(description, singleName);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.singleName = new Name(in);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.singleName = st.getName(origin);
    }

    @Override
    String rrToString() {
        return this.singleName.toString();
    }

    protected Name getSingleName() {
        return this.singleName;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.singleName.toWire(out, null, canonical);
    }
}

