/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;
import pluto.DNS.WireParseException;

public class LOCRecord
extends Record {
    private long size;
    private long hPrecision;
    private long vPrecision;
    private long latitude;
    private long longitude;
    private long altitude;

    LOCRecord() {
    }

    @Override
    Record getObject() {
        return new LOCRecord();
    }

    public LOCRecord(Name name, int dclass, long ttl, double latitude, double longitude, double altitude, double size, double hPrecision, double vPrecision) {
        super(name, 29, dclass, ttl);
        this.latitude = (long)(latitude * 3600.0 * 1000.0 + 2.147483648E9);
        this.longitude = (long)(longitude * 3600.0 * 1000.0 + 2.147483648E9);
        this.altitude = (long)((altitude + 100000.0) * 100.0);
        this.size = (long)(size * 100.0);
        this.hPrecision = (long)(hPrecision * 100.0);
        this.vPrecision = (long)(vPrecision * 100.0);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        int version = in.readU8();
        if (version != 0) {
            throw new WireParseException("Invalid LOC version");
        }
        this.size = LOCRecord.parseLOCformat(in.readU8());
        this.hPrecision = LOCRecord.parseLOCformat(in.readU8());
        this.vPrecision = LOCRecord.parseLOCformat(in.readU8());
        this.latitude = in.readU32();
        this.longitude = in.readU32();
        this.altitude = in.readU32();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String s = null;
        int min = 0;
        int deg = 0;
        double sec = 0.0;
        try {
            deg = st.getUInt16();
            min = st.getUInt16();
            sec = st.getDouble();
        }
        catch (NumberFormatException e) {
            st.unget();
        }
        s = st.getString();
        if (!s.equalsIgnoreCase("S") && !s.equalsIgnoreCase("N")) {
            throw st.exception("Invalid LOC latitude");
        }
        this.latitude = (long)(1000.0 * (sec + (double)(60 * (min + 60 * deg))));
        if (s.equalsIgnoreCase("S")) {
            this.latitude = -this.latitude;
        }
        this.latitude += 0x80000000L;
        min = 0;
        deg = 0;
        sec = 0.0;
        try {
            deg = st.getUInt16();
            min = st.getUInt16();
            sec = st.getDouble();
        }
        catch (NumberFormatException e) {
            st.unget();
        }
        s = st.getString();
        if (!s.equalsIgnoreCase("W") && !s.equalsIgnoreCase("E")) {
            throw st.exception("Invalid LOC longitude");
        }
        this.longitude = (long)(1000.0 * (sec + (double)(60 * (min + 60 * deg))));
        if (s.equalsIgnoreCase("W")) {
            this.longitude = -this.longitude;
        }
        this.longitude += 0x80000000L;
        Tokenizer.Token token = st.get();
        if (token.isEOL()) {
            st.unget();
            return;
        }
        s = token.value;
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.altitude = (long)((new Double(s) + 100000.0) * 100.0);
        }
        catch (NumberFormatException e) {
            throw st.exception("Invalid LOC altitude");
        }
        token = st.get();
        if (token.isEOL()) {
            st.unget();
            return;
        }
        s = token.value;
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.size = (long)(100.0 * new Double(s));
        }
        catch (NumberFormatException e) {
            throw st.exception("Invalid LOC size");
        }
        token = st.get();
        if (token.isEOL()) {
            st.unget();
            return;
        }
        s = token.value;
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.hPrecision = (long)(100.0 * new Double(s));
        }
        catch (NumberFormatException e) {
            throw st.exception("Invalid LOC horizontal precision");
        }
        token = st.get();
        if (token.isEOL()) {
            st.unget();
            return;
        }
        s = token.value;
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.vPrecision = (long)(100.0 * new Double(s));
        }
        catch (NumberFormatException e) {
            throw st.exception("Invalid LOC vertical precision");
        }
    }

    @Override
    String rrToString() {
        char direction;
        StringBuffer sb = new StringBuffer();
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(3);
        ((NumberFormat)nf).setGroupingUsed(false);
        long temp = this.latitude - 0x80000000L;
        if (temp < 0L) {
            temp = -temp;
            direction = 'S';
        } else {
            direction = 'N';
        }
        sb.append(temp / 3600000L);
        sb.append(" ");
        sb.append((temp %= 3600000L) / 60000L);
        sb.append(" ");
        sb.append(nf.format((double)(temp %= 60000L) / 1000.0));
        sb.append(" ");
        sb.append(direction);
        sb.append(" ");
        temp = this.longitude - 0x80000000L;
        if (temp < 0L) {
            temp = -temp;
            direction = 'W';
        } else {
            direction = 'E';
        }
        sb.append(temp / 3600000L);
        sb.append(" ");
        sb.append((temp %= 3600000L) / 60000L);
        sb.append(" ");
        sb.append(nf.format((double)(temp %= 60000L) / 1000.0));
        sb.append(" ");
        sb.append(direction);
        sb.append(" ");
        ((NumberFormat)nf).setMaximumFractionDigits(2);
        sb.append(nf.format((double)(this.altitude - 10000000L) / 100.0));
        sb.append("m ");
        sb.append(nf.format((double)this.size / 100.0));
        sb.append("m ");
        sb.append(nf.format((double)this.hPrecision / 100.0));
        sb.append("m ");
        sb.append(nf.format((double)this.vPrecision / 100.0));
        sb.append("m");
        return sb.toString();
    }

    public double getLatitude() {
        return (double)(this.latitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getLongitude() {
        return (double)(this.longitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getAltitude() {
        return (double)(this.altitude - 10000000L) / 100.0;
    }

    public double getSize() {
        return (double)this.size / 100.0;
    }

    public double getHPrecision() {
        return (double)this.hPrecision / 100.0;
    }

    public double getVPrecision() {
        return (double)this.vPrecision / 100.0;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU8(0);
        out.writeU8(this.toLOCformat(this.size));
        out.writeU8(this.toLOCformat(this.hPrecision));
        out.writeU8(this.toLOCformat(this.vPrecision));
        out.writeU32(this.latitude);
        out.writeU32(this.longitude);
        out.writeU32(this.altitude);
    }

    private static long parseLOCformat(int b) throws WireParseException {
        long out = b >> 4;
        int exp = b & 0xF;
        if (out > 9L || exp > 9) {
            throw new WireParseException("Invalid LOC Encoding");
        }
        while (exp-- > 0) {
            out *= 10L;
        }
        return out;
    }

    private byte toLOCformat(long l) {
        int exp = 0;
        while (l > 9L) {
            exp = (byte)(exp + 1);
            l = (l + 5L) / 10L;
        }
        return (byte)((l << 4) + (long)exp);
    }
}

