/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;

public class ISDNRecord
extends Record {
    private byte[] address;
    private byte[] subAddress;

    ISDNRecord() {
    }

    @Override
    Record getObject() {
        return new ISDNRecord();
    }

    public ISDNRecord(Name name, int dclass, long ttl, String address, String subAddress) {
        super(name, 20, dclass, ttl);
        try {
            this.address = ISDNRecord.byteArrayFromString(address);
            if (subAddress != null) {
                this.subAddress = ISDNRecord.byteArrayFromString(subAddress);
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readCountedString();
        if (in.remaining() > 0) {
            this.subAddress = in.readCountedString();
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.address = ISDNRecord.byteArrayFromString(st.getString());
            Tokenizer.Token t = st.get();
            if (t.isString()) {
                this.subAddress = ISDNRecord.byteArrayFromString(t.value);
            } else {
                st.unget();
            }
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public String getAddress() {
        return ISDNRecord.byteArrayToString(this.address, false);
    }

    public String getSubAddress() {
        if (this.subAddress == null) {
            return null;
        }
        return ISDNRecord.byteArrayToString(this.subAddress, false);
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.address);
        if (this.subAddress != null) {
            out.writeCountedString(this.subAddress);
        }
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ISDNRecord.byteArrayToString(this.address, true));
        if (this.subAddress != null) {
            sb.append(" ");
            sb.append(ISDNRecord.byteArrayToString(this.subAddress, true));
        }
        return sb.toString();
    }
}

