/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;

public class GPOSRecord
extends Record {
    private byte[] latitude;
    private byte[] longitude;
    private byte[] altitude;

    GPOSRecord() {
    }

    @Override
    Record getObject() {
        return new GPOSRecord();
    }

    public GPOSRecord(Name name, int dclass, long ttl, double longitude, double latitude, double altitude) {
        super(name, 27, dclass, ttl);
        if (longitude < -90.0 || longitude > 90.0) {
            throw new IllegalArgumentException("illegal longitude " + longitude);
        }
        if (latitude < -180.0 || latitude > 180.0) {
            throw new IllegalArgumentException("illegal latitude " + latitude);
        }
        this.longitude = Double.toString(longitude).getBytes();
        this.latitude = Double.toString(latitude).getBytes();
        this.altitude = Double.toString(altitude).getBytes();
    }

    public GPOSRecord(Name name, int dclass, long ttl, String longitude, String latitude, String altitude) {
        super(name, 27, dclass, ttl);
        try {
            this.longitude = GPOSRecord.byteArrayFromString(longitude);
            this.latitude = GPOSRecord.byteArrayFromString(latitude);
            this.altitude = GPOSRecord.byteArrayFromString(altitude);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.longitude = in.readCountedString();
        this.latitude = in.readCountedString();
        this.altitude = in.readCountedString();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.longitude = GPOSRecord.byteArrayFromString(st.getString());
            this.latitude = GPOSRecord.byteArrayFromString(st.getString());
            this.altitude = GPOSRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(GPOSRecord.byteArrayToString(this.longitude, true));
        sb.append(" ");
        sb.append(GPOSRecord.byteArrayToString(this.latitude, true));
        sb.append(" ");
        sb.append(GPOSRecord.byteArrayToString(this.altitude, true));
        return sb.toString();
    }

    public String getLongitudeString() {
        return GPOSRecord.byteArrayToString(this.longitude, false);
    }

    public double getLongitude() {
        return Double.parseDouble(this.getLongitudeString());
    }

    public String getLatitudeString() {
        return GPOSRecord.byteArrayToString(this.latitude, false);
    }

    public double getLatitude() {
        return Double.parseDouble(this.getLatitudeString());
    }

    public String getAltitudeString() {
        return GPOSRecord.byteArrayToString(this.altitude, false);
    }

    public double getAltitude() {
        return Double.parseDouble(this.getAltitudeString());
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.longitude);
        out.writeCountedString(this.latitude);
        out.writeCountedString(this.altitude);
    }
}

