/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;
import pluto.net.NetAddress;

public class ARecord
extends Record {
    private int addr;

    ARecord() {
    }

    @Override
    Record getObject() {
        return new ARecord();
    }

    private static final int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static final int fromArray(byte[] array) {
        return ARecord.fromBytes(array[0], array[1], array[2], array[3]);
    }

    private static final String toDottedQuad(int addr) {
        StringBuffer sb = new StringBuffer();
        sb.append(addr >>> 24 & 0xFF);
        sb.append(".");
        sb.append(addr >>> 16 & 0xFF);
        sb.append(".");
        sb.append(addr >>> 8 & 0xFF);
        sb.append(".");
        sb.append(addr & 0xFF);
        return sb.toString();
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 1, dclass, ttl);
        this.addr = ARecord.fromArray(address.getAddress());
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.addr = ARecord.fromArray(in.readByteArray(4));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String s = st.getString();
        try {
            if (s.equals("@me@")) {
                InetAddress address = InetAddress.getLocalHost();
                if (address.equals(InetAddress.getByName("127.0.0.1"))) {
                    String msg = "InetAddress.getLocalHost() is broken.  Don't use @me@.";
                    throw new RuntimeException(msg);
                }
                this.addr = ARecord.fromArray(address.getAddress());
            }
        }
        catch (UnknownHostException e) {
            throw st.exception("invalid address");
        }
        byte[] array = NetAddress.getByteArray(s);
        if (array == null) {
            throw st.exception("invalid dotted quad");
        }
        this.addr = ARecord.fromBytes(array[0], array[1], array[2], array[3]);
    }

    @Override
    String rrToString() {
        return ARecord.toDottedQuad(this.addr);
    }

    public InetAddress getAddress() {
        String s = ARecord.toDottedQuad(this.addr);
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

