/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Inet6Address;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;

public class AAAARecord
extends Record {
    private Inet6Address address;

    AAAARecord() {
    }

    @Override
    Record getObject() {
        return new AAAARecord();
    }

    public AAAARecord(Name name, int dclass, long ttl, Inet6Address address) {
        super(name, 28, dclass, ttl);
        this.address = address;
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.address = new Inet6Address(in.readByteArray(16));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.address = new Inet6Address(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    @Override
    String rrToString() {
        return this.address.toString();
    }

    public Inet6Address getAddress() {
        return this.address;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        byte[] b = this.address.toBytes();
        out.writeByteArray(b);
    }
}

